/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.direct.DirectMetaBean;

public final class DirectMetaPropertyMap
implements Map<String, MetaProperty<?>> {
    private final DirectMetaBean metaBean;
    private final Set<String> keys;
    private final Collection<MetaProperty<?>> values;
    private final Set<Map.Entry<String, MetaProperty<?>>> entries;

    public DirectMetaPropertyMap(DirectMetaBean metaBean, DirectMetaPropertyMap parent, String ... propertyNames) {
        Map.Entry[] metaProperties;
        if (metaBean == null) {
            throw new NullPointerException("MetaBean must not be null");
        }
        this.metaBean = metaBean;
        int parentSize = 0;
        if (parent != null) {
            parentSize = parent.size();
            metaProperties = Arrays.copyOf(((Entries)parent.entries).metaProperties, parentSize + propertyNames.length);
        } else {
            metaProperties = new Map.Entry[propertyNames.length];
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            metaProperties[i + parentSize] = new AbstractMap.SimpleImmutableEntry(propertyNames[i], metaBean.metaPropertyGet(propertyNames[i]));
        }
        this.keys = new Keys(metaProperties);
        this.values = new Values(metaProperties);
        this.entries = new Entries(metaProperties);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public MetaProperty<Object> get(Object propertyName) {
        if (propertyName instanceof String) {
            return this.metaBean.metaPropertyGet((String)propertyName);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object propertyName) {
        return propertyName instanceof String && this.metaBean.metaPropertyGet(propertyName.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return value instanceof MetaProperty && this.metaBean.metaPropertyGet(((MetaProperty)value).name()) != null;
    }

    @Override
    public MetaProperty<?> put(String key, MetaProperty<?> value) {
        throw new UnsupportedOperationException("DirectBean meta-property map cannot be modified");
    }

    @Override
    public MetaProperty<?> remove(Object key) {
        throw new UnsupportedOperationException("DirectBean meta-property map cannot be modified");
    }

    @Override
    public void putAll(Map<? extends String, ? extends MetaProperty<?>> m) {
        throw new UnsupportedOperationException("DirectBean meta-property map cannot be modified");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("DirectBean meta-property map cannot be modified");
    }

    @Override
    public Set<String> keySet() {
        return this.keys;
    }

    @Override
    public Collection<MetaProperty<?>> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, MetaProperty<?>>> entrySet() {
        return this.entries;
    }

    private static final class Entries
    extends AbstractSet<Map.Entry<String, MetaProperty<?>>> {
        private final Map.Entry<String, MetaProperty<?>>[] metaProperties;

        private Entries(Map.Entry<String, MetaProperty<?>>[] metaProperties) {
            this.metaProperties = metaProperties;
        }

        @Override
        public Iterator<Map.Entry<String, MetaProperty<?>>> iterator() {
            return new Iterator<Map.Entry<String, MetaProperty<?>>>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < metaProperties.length;
                }

                @Override
                public Map.Entry<String, MetaProperty<?>> next() {
                    return metaProperties[this.index++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.metaProperties.length;
        }
    }

    private static final class Values
    extends AbstractCollection<MetaProperty<?>> {
        private final Map.Entry<String, MetaProperty<?>>[] metaProperties;

        private Values(Map.Entry<String, MetaProperty<?>>[] metaProperties) {
            this.metaProperties = metaProperties;
        }

        @Override
        public Iterator<MetaProperty<?>> iterator() {
            return new Iterator<MetaProperty<?>>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < metaProperties.length;
                }

                @Override
                public MetaProperty<?> next() {
                    return (MetaProperty)metaProperties[this.index++].getValue();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.metaProperties.length;
        }
    }

    private static final class Keys
    extends AbstractSet<String> {
        private final Map.Entry<String, MetaProperty<?>>[] metaProperties;

        private Keys(Map.Entry<String, MetaProperty<?>>[] metaProperties) {
            this.metaProperties = metaProperties;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < metaProperties.length;
                }

                @Override
                public String next() {
                    return (String)metaProperties[this.index++].getKey();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.metaProperties.length;
        }
    }
}

