/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.bin.MsgPack;
import org.joda.beans.ser.bin.MsgPackInput;
import org.joda.beans.ser.bin.MsgPackVisualizer;

public class JodaBeanBinReader
extends MsgPack {
    private final JodaBeanSer settings;
    private DataInputStream input;
    private String basePackage;
    private Map<String, Class<?>> knownTypes = new HashMap();

    public static String visualize(byte[] input) {
        return new MsgPackVisualizer(input).visualizeData();
    }

    public JodaBeanBinReader(JodaBeanSer settings) {
        this.settings = settings;
    }

    public Bean read(byte[] input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(byte[] input, Class<T> rootType) {
        return this.read(new ByteArrayInputStream(input), rootType);
    }

    public Bean read(InputStream input) {
        return this.read(input, Bean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(InputStream input, Class<T> rootType) {
        this.input = input instanceof DataInputStream ? (DataInputStream)input : new DataInputStream(input);
        try {
            try {
                T t = this.parseRoot(rootType);
                return t;
            }
            finally {
                input.close();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T parseRoot(Class<T> declaredType) throws Exception {
        byte typeByte = this.input.readByte();
        if (typeByte != -110) {
            throw new IllegalArgumentException("Invalid binary data: Expected array, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        typeByte = this.input.readByte();
        if (typeByte != 1) {
            throw new IllegalArgumentException("Invalid binary data: Expected version 1, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        Object parsed = this.parseObject(declaredType, null, null, null, true);
        return declaredType.cast(parsed);
    }

    private Object parseBean(int propertyCount, Class<?> beanType) throws Exception {
        String propName = "";
        try {
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(beanType);
            MetaBean metaBean = deser.findMetaBean(beanType);
            BeanBuilder<?> builder = deser.createBuilder(beanType, metaBean);
            for (int i = 0; i < propertyCount; ++i) {
                propName = this.acceptString(this.input.readByte());
                MetaProperty<?> metaProp = deser.findMetaProperty(beanType, metaBean, propName);
                if (metaProp == null || metaProp.style().isDerived()) {
                    MsgPackInput.skipObject(this.input);
                } else {
                    Object value = this.parseObject(SerOptional.extractType(metaProp, beanType), metaProp, beanType, null, false);
                    deser.setValue(builder, metaProp, SerOptional.wrapValue(metaProp, beanType, value));
                }
                propName = "";
            }
            return deser.build(beanType, builder);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing bean: " + beanType.getName() + "::" + propName + ", " + ex.getMessage(), ex);
        }
    }

    private Object parseObject(Class<?> declaredType, MetaProperty<?> metaProp, Class<?> beanType, SerIterable parentIterable, boolean rootType) throws Exception {
        int mapSize;
        Class<?> effectiveType = declaredType;
        String metaType = null;
        byte typeByte = this.input.readByte();
        if (JodaBeanBinReader.isMap(typeByte)) {
            this.input.mark(8);
            mapSize = this.acceptMap(typeByte);
            if (mapSize > 0) {
                byte typeByteTemp = this.input.readByte();
                if (typeByteTemp == -57) {
                    int size = this.input.readUnsignedByte();
                    typeByteTemp = this.input.readByte();
                    if (typeByteTemp == 32) {
                        String typeStr = this.acceptStringBytes(size);
                        effectiveType = SerTypeMapper.decodeType(typeStr, this.settings, this.basePackage, this.knownTypes);
                        if (rootType) {
                            if (!Bean.class.isAssignableFrom(effectiveType)) {
                                throw new IllegalArgumentException("Root type is not a Joda-Bean: " + effectiveType.getName());
                            }
                            this.basePackage = effectiveType.getPackage().getName() + ".";
                        }
                        if (!declaredType.isAssignableFrom(effectiveType)) {
                            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + effectiveType.getName());
                        }
                        if (this.input.readByte() != -64) {
                            throw new IllegalArgumentException("Invalid binary data: Expected null after bean type");
                        }
                        return this.parseBean(mapSize - 1, effectiveType);
                    }
                    if (typeByteTemp == 33) {
                        if (mapSize != 1) {
                            throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                        }
                        String typeStr = this.acceptStringBytes(size);
                        effectiveType = this.settings.getDeserializers().decodeType(typeStr, this.settings, this.basePackage, this.knownTypes, declaredType);
                        if (!declaredType.isAssignableFrom(effectiveType)) {
                            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + effectiveType.getName());
                        }
                        typeByte = this.input.readByte();
                    } else if (typeByteTemp == 34) {
                        if (mapSize != 1) {
                            throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                        }
                        metaType = this.acceptStringBytes(size);
                        typeByte = this.input.readByte();
                    } else {
                        this.input.reset();
                    }
                } else {
                    this.input.reset();
                }
            } else {
                this.input.reset();
            }
        }
        if (typeByte == -64) {
            return null;
        }
        if (Bean.class.isAssignableFrom(effectiveType)) {
            if (JodaBeanBinReader.isMap(typeByte)) {
                mapSize = this.acceptMap(typeByte);
                return this.parseBean(mapSize, effectiveType);
            }
            return this.parseSimple(typeByte, effectiveType);
        }
        if (JodaBeanBinReader.isMap(typeByte) || JodaBeanBinReader.isArray(typeByte)) {
            SerIterable childIterable = null;
            if (metaType != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(metaType, this.settings, this.knownTypes);
            } else if (metaProp != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(metaProp, beanType);
            } else if (parentIterable != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(parentIterable);
            }
            if (childIterable == null) {
                throw new IllegalArgumentException("Invalid binary data: Invalid metaType: " + metaType);
            }
            return this.parseIterable(typeByte, childIterable);
        }
        return this.parseSimple(typeByte, effectiveType);
    }

    private Object parseIterable(int typeByte, SerIterable iterable) throws Exception {
        if (iterable.category() == SerCategory.MAP) {
            return this.parseIterableMap(typeByte, iterable);
        }
        if (iterable.category() == SerCategory.COUNTED) {
            return this.parseIterableCounted(typeByte, iterable);
        }
        if (iterable.category() == SerCategory.TABLE) {
            return this.parseIterableTable(typeByte, iterable);
        }
        if (iterable.category() == SerCategory.GRID) {
            return this.parseIterableGrid(typeByte, iterable);
        }
        return this.parseIterableArray(typeByte, iterable);
    }

    private Object parseIterableMap(int typeByte, SerIterable iterable) throws Exception {
        int size = this.acceptMap(typeByte);
        for (int i = 0; i < size; ++i) {
            Object key = this.parseObject(iterable.keyType(), null, null, null, false);
            Object value = this.parseObject(iterable.valueType(), null, null, iterable, false);
            iterable.add(key, null, value, 1);
        }
        return iterable.build();
    }

    private Object parseIterableTable(int typeByte, SerIterable iterable) throws Exception {
        int size = this.acceptArray(typeByte);
        for (int i = 0; i < size; ++i) {
            if (this.acceptArray(this.input.readByte()) != 3) {
                throw new IllegalArgumentException("Table must have cell array size 3");
            }
            Object key = this.parseObject(iterable.keyType(), null, null, null, false);
            Object column = this.parseObject(iterable.columnType(), null, null, null, false);
            Object value = this.parseObject(iterable.valueType(), null, null, iterable, false);
            iterable.add(key, column, value, 1);
        }
        return iterable.build();
    }

    private Object parseIterableGrid(int typeByte, SerIterable iterable) throws Exception {
        int size = this.acceptArray(typeByte);
        int rows = this.acceptInteger(this.input.readByte());
        int columns = this.acceptInteger(this.input.readByte());
        iterable.dimensions(new int[]{rows, columns});
        if (rows * columns != size - 2) {
            for (int i = 0; i < size - 2; ++i) {
                if (this.acceptArray(this.input.readByte()) != 3) {
                    throw new IllegalArgumentException("Grid must have cell array size 3");
                }
                int row = this.acceptInteger(this.input.readByte());
                int column = this.acceptInteger(this.input.readByte());
                Object value = this.parseObject(iterable.valueType(), null, null, iterable, false);
                iterable.add(row, column, value, 1);
            }
        } else {
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    Object value = this.parseObject(iterable.valueType(), null, null, iterable, false);
                    iterable.add(row, column, value, 1);
                }
            }
        }
        return iterable.build();
    }

    private Object parseIterableCounted(int typeByte, SerIterable iterable) throws Exception {
        int size = this.acceptMap(typeByte);
        for (int i = 0; i < size; ++i) {
            Object value = this.parseObject(iterable.valueType(), null, null, iterable, false);
            int count = this.acceptInteger(this.input.readByte());
            iterable.add(null, null, value, count);
        }
        return iterable.build();
    }

    private Object parseIterableArray(int typeByte, SerIterable iterable) throws Exception {
        int size = this.acceptArray(typeByte);
        for (int i = 0; i < size; ++i) {
            iterable.add(null, null, this.parseObject(iterable.valueType(), null, null, iterable, false), 1);
        }
        return iterable.build();
    }

    private Object parseSimple(int typeByte, Class<?> type) throws Exception {
        if (JodaBeanBinReader.isString(typeByte)) {
            String text = this.acceptString(typeByte);
            if (type == String.class || type == Object.class) {
                return text;
            }
            return this.settings.getConverter().convertFromString(type, text);
        }
        if (JodaBeanBinReader.isIntegral(typeByte)) {
            long value = this.acceptLong(typeByte);
            if (type == Long.class || type == Long.TYPE) {
                return value;
            }
            if (type == Short.class || type == Short.TYPE) {
                if (value < -32768L || value > 32767L) {
                    throw new IllegalArgumentException("Invalid binary data: Expected byte, but was " + value);
                }
                return (short)value;
            }
            if (type == Byte.class || type == Byte.TYPE) {
                if (value < -128L || value > 127L) {
                    throw new IllegalArgumentException("Invalid binary data: Expected byte, but was " + value);
                }
                return (byte)value;
            }
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid binary data: Expected int, but was " + value);
            }
            return (int)value;
        }
        switch (typeByte) {
            case -61: {
                return Boolean.TRUE;
            }
            case -62: {
                return Boolean.FALSE;
            }
            case -54: {
                return Float.valueOf(this.input.readFloat());
            }
            case -53: {
                return this.input.readDouble();
            }
            case -60: 
            case -59: 
            case -58: {
                return this.acceptBinary(typeByte);
            }
        }
        throw new IllegalArgumentException("Invalid binary data: Expected " + type.getName() + ", but was: 0x" + JodaBeanBinReader.toHex(typeByte));
    }

    private int acceptMap(int typeByte) throws IOException {
        int size;
        if (typeByte >= -128 && typeByte <= -113) {
            size = typeByte - -128;
        } else if (typeByte == -34) {
            size = this.input.readUnsignedShort();
        } else if (typeByte == -33) {
            size = this.input.readInt();
            if (size < 0) {
                throw new IllegalArgumentException("Invalid binary data: Map too large");
            }
        } else {
            throw new IllegalArgumentException("Invalid binary data: Expected map, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        return size;
    }

    private int acceptArray(int typeByte) throws IOException {
        int size;
        if (typeByte >= -112 && typeByte <= -97) {
            size = typeByte - -112;
        } else if (typeByte == -36) {
            size = this.input.readUnsignedShort();
        } else if (typeByte == -35) {
            size = this.input.readInt();
            if (size < 0) {
                throw new IllegalArgumentException("Invalid binary data: Array too large");
            }
        } else {
            throw new IllegalArgumentException("Invalid binary data: Expected array, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        return size;
    }

    private String acceptString(int typeByte) throws IOException {
        int size;
        if (typeByte >= -96 && typeByte <= -65) {
            size = typeByte - -96;
        } else if (typeByte == -39) {
            size = this.input.readUnsignedByte();
        } else if (typeByte == -38) {
            size = this.input.readUnsignedShort();
        } else if (typeByte == -37) {
            size = this.input.readInt();
            if (size < 0) {
                throw new IllegalArgumentException("Invalid binary data: String too large");
            }
        } else {
            throw new IllegalArgumentException("Invalid binary data: Expected string, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        return this.acceptStringBytes(size);
    }

    private String acceptStringBytes(int size) throws IOException {
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            byte b = bytes[i];
            if (b < 0) {
                return new String(bytes, UTF_8);
            }
            chars[i] = (char)b;
        }
        return new String(chars);
    }

    private byte[] acceptBinary(int typeByte) throws IOException {
        int size;
        if (typeByte == -60) {
            size = this.input.readUnsignedByte();
        } else if (typeByte == -59) {
            size = this.input.readUnsignedShort();
        } else if (typeByte == -58) {
            size = this.input.readInt();
            if (size < 0) {
                throw new IllegalArgumentException("Invalid binary data: Binary too large");
            }
        } else {
            throw new IllegalArgumentException("Invalid binary data: Expected binary, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
        }
        byte[] bytes = new byte[size];
        this.input.readFully(bytes);
        return bytes;
    }

    private int acceptInteger(int typeByte) throws IOException {
        if (typeByte >= -32 && typeByte <= 127) {
            return typeByte;
        }
        switch (typeByte) {
            case -52: {
                return this.input.readUnsignedByte();
            }
            case -51: {
                return this.input.readUnsignedShort();
            }
            case -50: {
                int val = this.input.readInt();
                if (val < 0) {
                    throw new IllegalArgumentException("Invalid binary data: Expected int, but was large unsigned int");
                }
                return val;
            }
            case -49: {
                long val = this.input.readLong();
                if (val < 0L || val > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid binary data: Expected int, but was large unsigned int");
                }
                return (int)val;
            }
            case -48: {
                return this.input.readByte();
            }
            case -47: {
                return this.input.readShort();
            }
            case -46: {
                return this.input.readInt();
            }
            case -45: {
                long val = this.input.readLong();
                if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid binary data: Expected int, but was large signed int");
                }
                return (int)val;
            }
        }
        throw new IllegalArgumentException("Invalid binary data: Expected int, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
    }

    private long acceptLong(int typeByte) throws IOException {
        if (typeByte >= -32 && typeByte <= 127) {
            return typeByte;
        }
        switch (typeByte) {
            case -52: {
                return this.input.readUnsignedByte();
            }
            case -51: {
                return this.input.readUnsignedShort();
            }
            case -50: {
                return (long)this.input.readInt() & 0xFFFFFFFFL;
            }
            case -49: {
                long val = this.input.readLong();
                if (val < 0L) {
                    throw new IllegalArgumentException("Invalid binary data: Expected long, but was large unsigned int");
                }
                return val;
            }
            case -48: {
                return this.input.readByte();
            }
            case -47: {
                return this.input.readShort();
            }
            case -46: {
                return this.input.readInt();
            }
            case -45: {
                return this.input.readLong();
            }
        }
        throw new IllegalArgumentException("Invalid binary data: Expected long, but was: 0x" + JodaBeanBinReader.toHex(typeByte));
    }
}

