/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerOptional;
import org.joda.convert.StringConverter;

public class JodaBeanSimpleMapWriter {
    private final JodaBeanSer settings;

    public JodaBeanSimpleMapWriter(JodaBeanSer settings) {
        JodaBeanUtils.notNull(settings, "settings");
        this.settings = settings;
    }

    public Map<String, Object> write(Bean bean) {
        JodaBeanUtils.notNull(bean, "bean");
        return this.writeBean(bean, bean.getClass());
    }

    private Map<String, Object> writeBean(Bean bean, Class<?> declaredType) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (MetaProperty<?> prop : bean.metaBean().metaPropertyIterable()) {
            SerIterator itemIterator;
            Object value;
            if (!prop.style().isSerializable() && (!prop.style().isDerived() || !this.settings.isIncludeDerived()) || (value = SerOptional.extractValue(prop, bean)) == null) continue;
            Object outputValue = null;
            Class<?> propType = SerOptional.extractType(prop, bean.getClass());
            outputValue = value instanceof Bean ? (this.settings.getConverter().isConvertible(value.getClass()) ? this.writeSimple(propType, value) : this.writeBean((Bean)value, propType)) : ((itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass(), true)) != null ? this.writeElements(itemIterator) : this.writeSimple(propType, value));
            result.put(prop.name(), outputValue);
        }
        return result;
    }

    private Object writeElements(SerIterator itemIterator) {
        if (itemIterator.category() == SerCategory.MAP) {
            return this.writeMap(itemIterator);
        }
        if (itemIterator.category() == SerCategory.COUNTED) {
            return this.writeCounted(itemIterator);
        }
        if (itemIterator.category() == SerCategory.TABLE) {
            return this.writeTable(itemIterator);
        }
        if (itemIterator.category() == SerCategory.GRID) {
            return this.writeGrid(itemIterator);
        }
        return this.writeArray(itemIterator);
    }

    private Object writeArray(SerIterator itemIterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            result.add(this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator));
        }
        return result;
    }

    private Object writeMap(SerIterator itemIterator) {
        if (itemIterator.size() == 0) {
            return new LinkedHashMap();
        }
        if (this.settings.getConverter().isConvertible(itemIterator.keyType())) {
            return this.writeMapSimple(itemIterator);
        }
        return this.writeMapComplex(itemIterator);
    }

    private Object writeMapSimple(SerIterator itemIterator) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        StringConverter keyConverter = this.settings.getConverter().findConverterNoGenerics(itemIterator.keyType());
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object key = itemIterator.key();
            if (key == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be null");
            }
            String str = keyConverter.convertToString(itemIterator.key());
            if (str == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be a null string");
            }
            result.put(str, this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator));
        }
        return result;
    }

    private Object writeMapComplex(SerIterator itemIterator) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object key = itemIterator.key();
            if (key == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be null");
            }
            String str = this.settings.getConverter().convertToString(itemIterator.key());
            if (str == null) {
                throw new IllegalArgumentException("Unable to write map key as it cannot be a null string");
            }
            result.put(str, this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator));
        }
        return result;
    }

    private Object writeTable(SerIterator itemIterator) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object outputKey = this.writeObject(itemIterator.keyType(), itemIterator.key(), null);
            Object outputCol = this.writeObject(itemIterator.columnType(), itemIterator.column(), null);
            Object outputValue = this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            result.add(Arrays.asList(outputKey, outputCol, outputValue));
        }
        return result;
    }

    private Object writeGrid(SerIterator itemIterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(itemIterator.dimensionSize(0));
        result.add(itemIterator.dimensionSize(1));
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Integer outputKey = (Integer)itemIterator.key();
            Integer outputCol = (Integer)itemIterator.column();
            Object outputValue = this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            result.add(Arrays.asList(outputKey, outputCol, outputValue));
        }
        return result;
    }

    private Object writeCounted(SerIterator itemIterator) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        while (itemIterator.hasNext()) {
            itemIterator.next();
            Object outputValue = this.writeObject(itemIterator.valueType(), itemIterator.value(), itemIterator);
            Integer outputCount = itemIterator.count();
            result.add(Arrays.asList(outputValue, outputCount));
        }
        return result;
    }

    private Object writeObject(Class<?> declaredType, Object obj, SerIterator parentIterator) {
        if (obj == null) {
            return null;
        }
        if (this.settings.getConverter().isConvertible(obj.getClass())) {
            return this.writeSimple(declaredType, obj);
        }
        if (obj instanceof Bean) {
            return this.writeBean((Bean)obj, declaredType);
        }
        if (parentIterator != null) {
            SerIterator childIterator = this.settings.getIteratorFactory().createChild(obj, parentIterator);
            if (childIterator != null) {
                return this.writeElements(childIterator);
            }
            return this.writeSimple(declaredType, obj);
        }
        return this.writeSimple(declaredType, obj);
    }

    private Object writeSimple(Class<?> declaredType, Object value) {
        Class<?> realType = value.getClass();
        if (realType == Integer.class || realType == Long.class || realType == Short.class || realType == Byte.class || realType == Float.class || realType == Double.class || realType == Boolean.class) {
            return value;
        }
        try {
            String converted = this.settings.getConverter().convertToString(realType, value);
            if (converted == null) {
                throw new IllegalArgumentException("Unable to write because converter returned a null string: " + value);
            }
            return converted;
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to convert type " + declaredType.getName() + " for real type: " + realType.getName(), ex);
        }
    }
}

