/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.StandaloneMetaProperty;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;

public final class JodaBeanTests {
    public static final String TEST_COVERAGE_PROPERTY = "!ConstantUsedForTestCoveragePurposes!";
    public static final String TEST_COVERAGE_STRING = "!ConstantUsedForTestCoveragePurposes!";
    private static final Map<Class<?>, List<?>> SAMPLES;

    public static void coverMutableBean(Bean bean) {
        JodaBeanTests.assertNotNull(bean, "coverImmutableBean() called with null bean");
        JodaBeanTests.assertFalse(bean instanceof ImmutableBean);
        JodaBeanTests.assertNotSame(JodaBeanUtils.clone(bean), bean);
        JodaBeanTests.coverBean(bean);
    }

    public static void coverImmutableBean(ImmutableBean bean) {
        JodaBeanTests.assertNotNull(bean, "coverImmutableBean() called with null bean");
        JodaBeanTests.assertSame(JodaBeanUtils.clone(bean), bean);
        JodaBeanTests.coverBean(bean);
    }

    public static void coverBeanEquals(Bean bean1, Bean bean2) {
        JodaBeanTests.assertNotNull(bean1, "coverBeanEquals() called with null bean");
        JodaBeanTests.assertNotNull(bean2, "coverBeanEquals() called with null bean");
        JodaBeanTests.assertFalse(bean1.equals(null));
        JodaBeanTests.assertFalse(bean1.equals("NonBean"));
        JodaBeanTests.assertTrue(bean1.equals(bean1));
        JodaBeanTests.assertTrue(bean2.equals(bean2));
        JodaBeanTests.ignoreThrows(() -> JodaBeanTests.assertEquals(bean1, JodaBeanUtils.cloneAlways(bean1)));
        JodaBeanTests.ignoreThrows(() -> JodaBeanTests.assertEquals(bean2, JodaBeanUtils.cloneAlways(bean2)));
        JodaBeanTests.assertTrue(bean1.hashCode() == bean1.hashCode());
        JodaBeanTests.assertTrue(bean2.hashCode() == bean2.hashCode());
        if (bean1.equals(bean2) || bean1.getClass() != bean2.getClass()) {
            return;
        }
        MetaBean metaBean = bean1.metaBean();
        List buildableProps = metaBean.metaPropertyMap().values().stream().filter(mp -> mp.style().isBuildable()).collect(Collectors.toList());
        HashSet<Bean> builtBeansSet = new HashSet<Bean>();
        builtBeansSet.add(bean1);
        builtBeansSet.add(bean2);
        for (int i = 0; i < buildableProps.size(); ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    BeanBuilder<? extends Bean> bld = metaBean.builder();
                    for (int k = 0; k < buildableProps.size(); ++k) {
                        MetaProperty mp2 = (MetaProperty)buildableProps.get(k);
                        if (j == 0) {
                            bld.set(mp2, mp2.get(k < i ? bean1 : bean2));
                            continue;
                        }
                        bld.set(mp2, mp2.get(i <= k ? bean1 : bean2));
                    }
                    builtBeansSet.add(bld.build());
                    continue;
                }
                catch (RuntimeException bld) {
                    // empty catch block
                }
            }
        }
        ArrayList builtBeansList = new ArrayList(builtBeansSet);
        for (int i = 0; i < builtBeansList.size() - 1; ++i) {
            for (int j = i + 1; j < builtBeansList.size(); ++j) {
                ((Bean)builtBeansList.get(i)).equals(builtBeansList.get(j));
            }
        }
    }

    private static void coverBean(Bean bean) {
        JodaBeanTests.coverProperties(bean);
        JodaBeanTests.coverNonProperties(bean);
        JodaBeanTests.coverEquals(bean);
    }

    private static void coverProperties(Bean bean) {
        MetaBean metaBean = bean.metaBean();
        Map<String, MetaProperty<?>> metaPropMap = metaBean.metaPropertyMap();
        JodaBeanTests.assertNotNull(metaPropMap);
        JodaBeanTests.assertEquals(metaBean.metaPropertyCount(), metaPropMap.size());
        for (MetaProperty<?> mp : metaBean.metaPropertyIterable()) {
            JodaBeanTests.assertTrue(metaBean.metaPropertyExists(mp.name()));
            JodaBeanTests.assertEquals(metaBean.metaProperty(mp.name()), mp);
            JodaBeanTests.assertEquals(metaBean.metaProperty(new String(mp.name())), mp);
            JodaBeanTests.assertEquals(metaPropMap.values().contains(mp), true);
            JodaBeanTests.assertEquals(metaPropMap.keySet().contains(mp.name()), true);
            if (mp.style().isReadable()) {
                JodaBeanTests.ignoreThrows(() -> mp.get(bean));
            } else {
                JodaBeanTests.assertThrows(() -> mp.get(bean), UnsupportedOperationException.class);
            }
            if (mp.style().isWritable()) {
                JodaBeanTests.ignoreThrows(() -> mp.set(bean, ""));
            } else {
                JodaBeanTests.assertThrows(() -> mp.set(bean, ""), UnsupportedOperationException.class);
            }
            if (mp.style().isBuildable()) {
                JodaBeanTests.ignoreThrows(() -> metaBean.builder().get(mp));
                JodaBeanTests.ignoreThrows(() -> metaBean.builder().get(mp.name()));
                for (Object setValue : JodaBeanTests.sampleValues(mp)) {
                    JodaBeanTests.ignoreThrows(() -> metaBean.builder().set(mp, setValue));
                }
                for (Object setValue : JodaBeanTests.sampleValues(mp)) {
                    JodaBeanTests.ignoreThrows(() -> metaBean.builder().set(mp.name(), setValue));
                }
            }
            JodaBeanTests.ignoreThrows(() -> {
                Method m = metaBean.getClass().getDeclaredMethod(mp.name(), new Class[0]);
                m.setAccessible(true);
                m.invoke((Object)metaBean, new Object[0]);
            });
            JodaBeanTests.ignoreThrows(() -> {
                Method m = metaBean.getClass().getDeclaredMethod("propertySet", Bean.class, String.class, Object.class, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke((Object)metaBean, bean, mp.name(), "", true);
            });
        }
        JodaBeanTests.ignoreThrows(() -> {
            Method m = metaBean.getClass().getDeclaredMethod("propertyGet", Bean.class, String.class, Boolean.TYPE);
            m.setAccessible(true);
            m.invoke((Object)metaBean, bean, "Not a real property name", true);
        });
        StandaloneMetaProperty<String> fakeMetaProp = StandaloneMetaProperty.of("fake", metaBean, String.class);
        JodaBeanTests.ignoreThrows(() -> metaBean.builder().set(fakeMetaProp, (Object)"!ConstantUsedForTestCoveragePurposes!"));
        JodaBeanTests.ignoreThrows(() -> metaBean.builder().set("!ConstantUsedForTestCoveragePurposes!", (Object)"!ConstantUsedForTestCoveragePurposes!"));
        JodaBeanTests.ignoreThrows(() -> bean.property("!ConstantUsedForTestCoveragePurposes!"));
    }

    private static void assertNotNull(Map<String, MetaProperty<?>> metaPropMap) {
    }

    private static void coverNonProperties(Bean bean) {
        MetaBean metaBean = bean.metaBean();
        JodaBeanTests.assertFalse(metaBean.metaPropertyExists(""));
        JodaBeanTests.assertThrows(() -> metaBean.builder().get("foo_bar"), NoSuchElementException.class);
        JodaBeanTests.assertThrows(() -> metaBean.builder().set("foo_bar", (Object)""), NoSuchElementException.class);
        JodaBeanTests.assertThrows(() -> metaBean.metaProperty("foo_bar"), NoSuchElementException.class);
        if (metaBean instanceof DirectMetaBean) {
            DirectMetaProperty<String> dummy = DirectMetaProperty.ofReadWrite(metaBean, "foo_bar", metaBean.beanType(), String.class);
            JodaBeanTests.assertThrows(() -> {
                String cfr_ignored_0 = (String)dummy.get(bean);
            }, NoSuchElementException.class);
            JodaBeanTests.assertThrows(() -> dummy.set(bean, ""), NoSuchElementException.class);
            JodaBeanTests.assertThrows(() -> dummy.setString(bean, ""), NoSuchElementException.class);
            JodaBeanTests.assertThrows(() -> {
                String cfr_ignored_0 = (String)metaBean.builder().get(dummy);
            }, NoSuchElementException.class);
            JodaBeanTests.assertThrows(() -> metaBean.builder().set(dummy, (Object)""), NoSuchElementException.class);
        }
        Set<String> propertyNameSet = bean.propertyNames();
        JodaBeanTests.assertNotNull(propertyNameSet);
        for (String propertyName : propertyNameSet) {
            JodaBeanTests.assertNotNull(bean.property(propertyName));
        }
        JodaBeanTests.assertThrows(() -> bean.property(""), NoSuchElementException.class);
        Class<?> beanClass = bean.getClass();
        JodaBeanTests.ignoreThrows(() -> {
            Method m = beanClass.getDeclaredMethod("meta", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        });
        JodaBeanTests.ignoreThrows(() -> {
            Method m = beanClass.getDeclaredMethod("meta" + beanClass.getSimpleName(), Class.class);
            m.setAccessible(true);
            m.invoke(null, String.class);
        });
        JodaBeanTests.ignoreThrows(() -> {
            Method m = beanClass.getDeclaredMethod("meta" + beanClass.getSimpleName(), Class.class, Class.class);
            m.setAccessible(true);
            m.invoke(null, String.class, String.class);
        });
        JodaBeanTests.ignoreThrows(() -> {
            Method m = beanClass.getDeclaredMethod("meta" + beanClass.getSimpleName(), Class.class, Class.class, Class.class);
            m.setAccessible(true);
            m.invoke(null, String.class, String.class, String.class);
        });
        JodaBeanTests.ignoreThrows(() -> {
            Method m = bean.getClass().getDeclaredMethod("builder", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        });
        JodaBeanTests.ignoreThrows(() -> {
            Method m = bean.getClass().getDeclaredMethod("toBuilder", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)bean, new Object[0]);
        });
        JodaBeanTests.assertNotNull(bean.toString());
        JodaBeanTests.assertNotNull(metaBean.toString());
        JodaBeanTests.assertNotNull(metaBean.builder().toString());
    }

    private static void coverEquals(Bean bean) {
        List buildableProps = bean.metaBean().metaPropertyMap().values().stream().filter(mp -> mp.style().isBuildable()).collect(Collectors.toList());
        for (int i = 0; i < buildableProps.size(); ++i) {
            try {
                BeanBuilder<? extends Bean> bld = bean.metaBean().builder();
                for (int j = 0; j < buildableProps.size(); ++j) {
                    MetaProperty mp2 = (MetaProperty)buildableProps.get(j);
                    if (j < i) {
                        bld.set(mp2, mp2.get(bean));
                        continue;
                    }
                    List<?> samples = JodaBeanTests.sampleValues(mp2);
                    bld.set(mp2, samples.get(0));
                }
                Bean built = bld.build();
                JodaBeanTests.coverBeanEquals(bean, built);
                JodaBeanTests.assertEquals(built, built);
                JodaBeanTests.assertEquals(built.hashCode(), built.hashCode());
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        JodaBeanTests.assertFalse(bean.equals(null));
        JodaBeanTests.assertFalse(bean.equals("NonBean"));
        JodaBeanTests.assertTrue(bean.equals(bean));
        JodaBeanTests.ignoreThrows(() -> JodaBeanTests.assertEquals(bean, JodaBeanUtils.cloneAlways(bean)));
        JodaBeanTests.assertTrue(bean.hashCode() == bean.hashCode());
    }

    private static List<?> sampleValues(MetaProperty<?> mp) {
        Class<?> type = mp.propertyType();
        if (Enum.class.isAssignableFrom(type)) {
            return Arrays.asList(type.getEnumConstants());
        }
        List<?> sample = SAMPLES.get(type);
        if (sample != null) {
            return sample;
        }
        String typeName = type.getName();
        ArrayList<Object> samples = new ArrayList<Object>();
        samples.addAll(JodaBeanTests.buildSampleConstants(type, type));
        JodaBeanTests.ignoreThrows(() -> samples.addAll(JodaBeanTests.buildSampleConstants(Class.forName(typeName + "s"), type)));
        JodaBeanTests.ignoreThrows(() -> samples.addAll(JodaBeanTests.buildSampleConstants(Class.forName(typeName + "es"), type)));
        JodaBeanTests.ignoreThrows(() -> samples.addAll(JodaBeanTests.buildSampleConstants(Class.forName(typeName.substring(0, typeName.length() - 1) + "ies"), type)));
        JodaBeanTests.ignoreThrows(() -> samples.addAll(JodaBeanTests.buildSampleConstants(Class.forName(typeName.substring(0, typeName.length() - 2) + "ices"), type)));
        return samples;
    }

    private static List<Object> buildSampleConstants(Class<?> queryType, Class<?> targetType) {
        ArrayList<Object> samples = new ArrayList<Object>();
        for (Field field : queryType.getFields()) {
            if (field.getType() != targetType || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || field.isSynthetic()) continue;
            JodaBeanTests.ignoreThrows(() -> samples.add(field.get(null)));
        }
        return samples;
    }

    private static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new AssertionError((Object)"Expected (a != null), but found (a == null)");
        }
    }

    private static void assertNotNull(Object obj, String message) {
        if (obj == null) {
            throw new AssertionError((Object)message);
        }
    }

    private static void assertSame(Object a, Object b) {
        if (a != b) {
            throw new AssertionError((Object)"Expected (a == b), but found (a != b)");
        }
    }

    private static void assertNotSame(Object a, Object b) {
        if (a == b) {
            throw new AssertionError((Object)"Expected (a != b), but found (a == b)");
        }
    }

    private static void assertEquals(Object actual, Object expected) {
        if (!Objects.equals(actual, expected)) {
            throw new AssertionError((Object)("Expected " + expected + ", but found " + actual));
        }
    }

    private static void assertEquals(int actual, int expected) {
        if (actual != expected) {
            throw new AssertionError((Object)("Expected " + expected + ", but found " + actual));
        }
    }

    private static void assertTrue(boolean actual) {
        if (!actual) {
            throw new AssertionError((Object)"Expected value to be true, but was false");
        }
    }

    private static void assertFalse(boolean actual) {
        if (actual) {
            throw new AssertionError((Object)"Expected value to be false, but was true");
        }
    }

    private static void assertThrows(AssertRunnable runner, Class<? extends Throwable> expected) {
        JodaBeanTests.assertNotNull(runner, "assertThrows() called with null AssertRunnable");
        JodaBeanTests.assertNotNull(expected, "assertThrows() called with null expected Class");
        try {
            runner.run();
            throw new AssertionError((Object)("Expected " + expected.getSimpleName() + " but code succeeded normally"));
        }
        catch (AssertionError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (!expected.isInstance(ex)) {
                throw new AssertionError("Expected " + expected.getSimpleName() + " but received " + ex.getClass().getSimpleName(), ex);
            }
            return;
        }
    }

    private static void ignoreThrows(AssertRunnable runner) {
        JodaBeanTests.assertNotNull(runner, "ignoreThrows() called with null AssertRunnable");
        try {
            runner.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Method method;
        Class<?> cls2;
        HashMap map = new HashMap();
        map.put(String.class, Arrays.asList("Hello", "Goodbye", " ", ""));
        map.put(Byte.class, Arrays.asList((byte)0, (byte)1));
        map.put(Byte.TYPE, Arrays.asList((byte)0, (byte)1));
        map.put(Short.class, Arrays.asList((short)0, (short)1));
        map.put(Short.TYPE, Arrays.asList((short)0, (short)1));
        map.put(Integer.class, Arrays.asList(0, 1));
        map.put(Integer.TYPE, Arrays.asList(0, 1));
        map.put(Long.class, Arrays.asList(0L, 1L));
        map.put(Long.TYPE, Arrays.asList(0L, 1L));
        map.put(Float.class, Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f)));
        map.put(Float.TYPE, Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f)));
        map.put(Double.class, Arrays.asList(0.0, 1.0));
        map.put(Double.TYPE, Arrays.asList(0.0, 1.0));
        map.put(Character.class, Arrays.asList(Character.valueOf(' '), Character.valueOf('A'), Character.valueOf('z')));
        map.put(Character.TYPE, Arrays.asList(Character.valueOf(' '), Character.valueOf('A'), Character.valueOf('z')));
        map.put(Boolean.class, Arrays.asList(Boolean.TRUE, Boolean.FALSE));
        map.put(Boolean.TYPE, Arrays.asList(Boolean.TRUE, Boolean.FALSE));
        map.put(LocalDate.class, Arrays.asList(LocalDate.now(ZoneOffset.UTC), LocalDate.of(2012, 6, 30)));
        map.put(LocalTime.class, Arrays.asList(LocalTime.now(ZoneOffset.UTC), LocalTime.of(11, 30)));
        map.put(LocalDateTime.class, Arrays.asList(LocalDateTime.now(ZoneOffset.UTC), LocalDateTime.of(2012, 6, 30, 11, 30)));
        map.put(OffsetTime.class, Arrays.asList(OffsetTime.now(ZoneOffset.UTC), OffsetTime.of(11, 30, 0, 0, ZoneOffset.ofHours(1))));
        map.put(OffsetDateTime.class, Arrays.asList(OffsetDateTime.now(ZoneOffset.UTC), OffsetDateTime.of(2012, 6, 30, 11, 30, 0, 0, ZoneOffset.ofHours(1))));
        map.put(ZonedDateTime.class, Arrays.asList(ZonedDateTime.now(ZoneOffset.UTC), ZonedDateTime.of(2012, 6, 30, 11, 30, 0, 0, ZoneId.systemDefault())));
        map.put(Instant.class, Arrays.asList(Instant.now(), Instant.EPOCH));
        map.put(Year.class, Arrays.asList(Year.now(ZoneOffset.UTC), Year.of(2012)));
        map.put(YearMonth.class, Arrays.asList(YearMonth.now(ZoneOffset.UTC), YearMonth.of(2012, 6)));
        map.put(MonthDay.class, Arrays.asList(MonthDay.now(ZoneOffset.UTC), MonthDay.of(12, 25)));
        map.put(Month.class, Arrays.asList(Month.JULY, Month.DECEMBER));
        map.put(DayOfWeek.class, Arrays.asList(DayOfWeek.FRIDAY, DayOfWeek.SATURDAY));
        map.put(URI.class, Arrays.asList(URI.create("http://www.opengamma.com"), URI.create("http://www.joda.org")));
        map.put(Class.class, Arrays.asList(Throwable.class, RuntimeException.class, String.class));
        map.put(Object.class, Arrays.asList("", 6));
        map.put(Collection.class, Arrays.asList(new ArrayList()));
        map.put(List.class, Arrays.asList(new ArrayList()));
        map.put(Set.class, Arrays.asList(new HashSet()));
        map.put(SortedSet.class, Arrays.asList(new TreeSet()));
        try {
            cls2 = Class.forName("com.google.common.collect.ImmutableList");
            method = cls2.getDeclaredMethod("of", new Class[0]);
            map.put(cls2, Arrays.asList(method.invoke(null, new Object[0])));
        }
        catch (Exception cls2) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("com.google.common.collect.ImmutableSet");
            method = cls2.getDeclaredMethod("of", new Class[0]);
            map.put(cls2, Arrays.asList(method.invoke(null, new Object[0])));
        }
        catch (Exception cls3) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("com.google.common.collect.ImmutableSortedSet");
            method = cls2.getDeclaredMethod("naturalOrder", new Class[0]);
            map.put(cls2, Arrays.asList(method.invoke(null, new Object[0])));
        }
        catch (Exception cls4) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("com.google.common.collect.ImmutableMap");
            method = cls2.getDeclaredMethod("of", new Class[0]);
            map.put(cls2, Arrays.asList(method.invoke(null, new Object[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SAMPLES = map;
    }

    @FunctionalInterface
    static interface AssertRunnable {
        public void run() throws Throwable;
    }
}

