/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerOptional;

final class BeanReferences {
    private final JodaBeanSer settings;
    private final Map<Class<?>, ClassInfo> classes = new HashMap();
    private final Map<Class<?>, Integer> classSerializationCount = new LinkedHashMap();
    private final List<ClassInfo> classInfoList = new ArrayList<ClassInfo>();
    private final Map<Object, Ref> refs = new HashMap<Object, Ref>();

    static BeanReferences find(ImmutableBean root, JodaBeanSer settings) {
        BeanReferences references = new BeanReferences(settings);
        references.findReferences(root);
        return references;
    }

    private BeanReferences(JodaBeanSer settings) {
        this.settings = settings;
    }

    private void findReferences(ImmutableBean root) {
        this.classes.put(root.getClass(), this.classInfoFromMetaBean(root.metaBean()));
        this.classSerializationCount.put(root.getClass(), 1);
        LinkedHashMap<Object, Integer> objects = new LinkedHashMap<Object, Integer>();
        this.findReferencesBean(root, root.getClass(), objects, null);
        List refEntries = objects.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(Map.Entry::getValue))).filter(entry -> (Integer)entry.getValue() > 1).collect(Collectors.toList());
        for (Map.Entry entry2 : refEntries) {
            Object value = entry2.getKey();
            Class<?> realType = value.getClass();
            if (realType == Integer.class || realType == Double.class || realType == Float.class || realType == Boolean.class || realType == Long.class || realType == Short.class || realType == Byte.class || realType == byte[].class) continue;
            this.refs.put(value, new Ref(false, this.refs.size()));
        }
        this.classInfoList.addAll(this.classSerializationCount.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(Map.Entry::getValue))).map(entry -> this.classes.get(entry.getKey())).collect(Collectors.toList()));
        int position = 0;
        while (position < this.classInfoList.size()) {
            ClassInfo classInfo = this.classInfoList.get(position);
            classInfo.position = position++;
        }
    }

    private void findReferencesBean(Object base, Class<?> declaredClass, Map<Object, Integer> objects, SerIterator parentIterator) {
        if (base == null) {
            return;
        }
        int result = objects.compute(base, BeanReferences::incrementOrOne);
        if (result > 1) {
            return;
        }
        if (base instanceof Bean) {
            this.addClassInfo(base, declaredClass);
            Bean bean = (Bean)base;
            if (this.settings.getConverter().isConvertible(bean.getClass())) {
                return;
            }
            for (MetaProperty<?> prop : bean.metaBean().metaPropertyIterable()) {
                if (!this.settings.isSerialized(prop)) continue;
                Object value = prop.get(bean);
                Class<?> type = SerOptional.extractType(prop, base.getClass());
                if (value == null) continue;
                SerIterator itemIterator = this.settings.getIteratorFactory().create(value, prop, bean.getClass());
                if (itemIterator != null) {
                    if (itemIterator.metaTypeRequired()) {
                        objects.compute(itemIterator.metaTypeName(), BeanReferences::incrementOrOne);
                    }
                    this.findReferencesIterable(itemIterator, objects);
                    continue;
                }
                this.findReferencesBean(value, type, objects, null);
            }
        } else if (parentIterator != null) {
            SerIterator childIterator = this.settings.getIteratorFactory().createChild(base, parentIterator);
            if (childIterator != null) {
                this.findReferencesIterable(childIterator, objects);
            } else {
                this.addClassInfo(base, declaredClass);
            }
        } else {
            this.addClassInfo(base, declaredClass);
        }
    }

    private void findReferencesIterable(SerIterator itemIterator, Map<Object, Integer> objects) {
        if (itemIterator.category() == SerCategory.MAP) {
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.findReferencesBean(itemIterator.key(), itemIterator.keyType(), objects, null);
                this.findReferencesBean(itemIterator.value(), itemIterator.valueType(), objects, itemIterator);
            }
        } else if (itemIterator.category() == SerCategory.COUNTED) {
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.findReferencesBean(itemIterator.value(), itemIterator.valueType(), objects, itemIterator);
            }
        } else if (itemIterator.category() == SerCategory.TABLE) {
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.findReferencesBean(itemIterator.key(), itemIterator.keyType(), objects, null);
                this.findReferencesBean(itemIterator.column(), itemIterator.columnType(), objects, null);
                this.findReferencesBean(itemIterator.value(), itemIterator.valueType(), objects, itemIterator);
            }
        } else if (itemIterator.category() == SerCategory.GRID) {
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.findReferencesBean(itemIterator.value(), itemIterator.valueType(), objects, itemIterator);
            }
        } else {
            while (itemIterator.hasNext()) {
                itemIterator.next();
                this.findReferencesBean(itemIterator.value(), itemIterator.valueType(), objects, itemIterator);
            }
        }
    }

    private void addClassInfo(Object value, Class<?> declaredClass) {
        if (value instanceof Bean && !(value instanceof ImmutableBean)) {
            throw new IllegalArgumentException("Can only serialize immutable beans in referencing binary format: " + value.getClass().getName());
        }
        if (value instanceof ImmutableBean) {
            boolean noNeedToSerializeTypeName;
            boolean isConvertible = this.settings.getConverter().isConvertible(value.getClass());
            boolean bl = noNeedToSerializeTypeName = declaredClass.equals(value.getClass()) && (this.classes.containsKey(value.getClass()) || isConvertible);
            if (noNeedToSerializeTypeName) {
                return;
            }
            ImmutableBean bean = (ImmutableBean)value;
            ClassInfo classInfo = isConvertible ? new ClassInfo(value.getClass(), new MetaProperty[0]) : this.classInfoFromMetaBean(bean.metaBean());
            this.addClassInfoAndIncrementCount(bean.getClass(), classInfo);
        } else if (declaredClass == Object.class && !value.getClass().equals(String.class)) {
            Class effectiveType = this.settings.getConverter().findTypedConverter(value.getClass()).getEffectiveType();
            ClassInfo classInfo = new ClassInfo(effectiveType, new MetaProperty[0]);
            this.addClassInfoAndIncrementCount(effectiveType, classInfo);
        } else if (!this.settings.getConverter().isConvertible(declaredClass)) {
            ClassInfo classInfo = new ClassInfo(value.getClass(), new MetaProperty[0]);
            this.addClassInfoAndIncrementCount(value.getClass(), classInfo);
        }
    }

    private void addClassInfoAndIncrementCount(Class<?> type, ClassInfo classInfo) {
        this.classes.putIfAbsent(type, classInfo);
        this.classSerializationCount.compute(type, BeanReferences::incrementOrOne);
    }

    private ClassInfo classInfoFromMetaBean(MetaBean metaBean) {
        MetaProperty[] metaProperties = (MetaProperty[])StreamSupport.stream(metaBean.metaPropertyIterable().spliterator(), false).filter(metaProp -> this.settings.isSerialized((MetaProperty<?>)metaProp)).toArray(MetaProperty[]::new);
        return new ClassInfo(metaBean.beanType(), metaProperties);
    }

    private static int incrementOrOne(Object k, Integer i) {
        return i == null ? 1 : Math.addExact(i, 1);
    }

    Map<Object, Ref> getReferences() {
        return this.refs;
    }

    List<ClassInfo> getClassInfoList() {
        return this.classInfoList;
    }

    ClassInfo getClassInfo(Class<?> effectiveType) {
        ClassInfo classInfo = this.classes.get(effectiveType);
        if (classInfo == null) {
            throw new IllegalStateException("Tried to serialise class that wasn't present in bean on first pass: " + effectiveType.getName());
        }
        return classInfo;
    }

    static final class Ref {
        boolean hasBeenSerialized;
        final int position;

        private Ref(boolean hasBeenSerialized, int position) {
            this.hasBeenSerialized = hasBeenSerialized;
            this.position = position;
        }

        void sent() {
            this.hasBeenSerialized = true;
        }

        public String toString() {
            return "Ref{hasBeenSerialized=" + this.hasBeenSerialized + ", position=" + this.position + '}';
        }
    }

    static final class ClassInfo {
        final Class<?> type;
        final MetaProperty<?>[] metaProperties;
        int position;

        private ClassInfo(Class<?> type, MetaProperty<?>[] metaProperties) {
            this.type = type;
            this.metaProperties = metaProperties;
            this.position = -1;
        }

        public String toString() {
            return "ClassInfo{position=" + this.position + ", type=" + this.type + ", metaProperties=" + Arrays.toString(this.metaProperties) + '}';
        }
    }
}

