/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.bin.JodaBeanReferencingBinWriter;
import org.joda.beans.ser.bin.JodaBeanStandardBinWriter;

public class JodaBeanBinWriter {
    private final JodaBeanSer settings;
    private final boolean referencing;

    public JodaBeanBinWriter(JodaBeanSer settings) {
        this(settings, false);
    }

    public JodaBeanBinWriter(JodaBeanSer settings, boolean referencing) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.settings = settings;
        this.referencing = referencing;
    }

    public byte[] write(Bean bean) {
        return this.write(bean, true);
    }

    public byte[] write(Bean bean, boolean rootType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            this.write(bean, rootType, baos);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return baos.toByteArray();
    }

    public void write(Bean bean, OutputStream output) throws IOException {
        this.write(bean, true, output);
    }

    public void write(Bean bean, boolean rootType, OutputStream output) throws IOException {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        if (this.referencing) {
            if (!(bean instanceof ImmutableBean)) {
                throw new IllegalArgumentException("Referencing binary format can only write ImmutableBean instances: " + bean.getClass().getName());
            }
            new JodaBeanReferencingBinWriter(this.settings, output).write((ImmutableBean)bean);
        } else {
            new JodaBeanStandardBinWriter(this.settings, output).write(bean, rootType);
        }
    }
}

