/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.PropertyData;

abstract class GetterGen {
    GetterGen() {
    }

    abstract List<String> generateGetter(PropertyData var1);

    String generateGetInvoke(PropertyData prop) {
        return "get" + prop.getUpperName() + "()";
    }

    private static List<String> doGenerateGetter(PropertyData prop, String access, String prefix, String expression) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\t/**");
        list.add("\t * Gets " + prop.getFirstComment());
        for (String comment : prop.getComments()) {
            list.add("\t * " + comment);
        }
        list.add("\t * @return the value of the property" + prop.getNotNullJavadoc());
        if (prop.getDeprecatedComment() != null) {
            list.add("\t * " + prop.getDeprecatedComment());
        }
        list.add("\t */");
        if (prop.isOverrideGet()) {
            list.add("\t@Override");
        }
        if (prop.isDeprecated()) {
            list.add("\t@Deprecated");
        }
        list.add("\t" + access + prop.getType() + " " + prefix + prop.getUpperName() + "() {");
        list.add("\t\treturn " + expression + ";");
        list.add("\t}");
        list.add("");
        return list;
    }

    static class NoGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new NoGetterGen();

        NoGetterGen() {
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return Collections.emptyList();
        }

        @Override
        String generateGetInvoke(PropertyData prop) {
            return prop.getFieldName();
        }
    }

    static class ManualGetterGen
    extends GetterGen {
        static final GetterGen INSTANCE = new ManualGetterGen();

        ManualGetterGen() {
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return Collections.emptyList();
        }
    }

    static final class OptionalGuavaGetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new OptionalGuavaGetterGen();

        OptionalGuavaGetterGen() {
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Gets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @return the optional value of the property, not null");
            if (prop.getDeprecatedComment() != null) {
                list.add("\t * " + prop.getDeprecatedComment());
            }
            list.add("\t */");
            if (prop.isOverrideGet()) {
                list.add("\t@Override");
            }
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            list.add("\tpublic Optional<" + prop.getType() + "> get" + prop.getUpperName() + "() {");
            list.add("\t\treturn Optional.fromNullable(" + prop.getFieldName() + ");");
            list.add("\t}");
            list.add("");
            return list;
        }

        @Override
        String generateGetInvoke(PropertyData prop) {
            return prop.getFieldName();
        }
    }

    static final class Optional8GetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new Optional8GetterGen();

        Optional8GetterGen() {
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Gets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @return the optional value of the property, not null");
            if (prop.getDeprecatedComment() != null) {
                list.add("\t * " + prop.getDeprecatedComment());
            }
            list.add("\t */");
            if (prop.isOverrideGet()) {
                list.add("\t@Override");
            }
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            if ("Double".equals(prop.getType())) {
                list.add("\tpublic OptionalDouble get" + prop.getUpperName() + "() {");
                list.add("\t\treturn " + prop.getFieldName() + " != null ? OptionalDouble.of(" + prop.getFieldName() + ") : OptionalDouble.empty();");
            } else if ("Integer".equals(prop.getType())) {
                list.add("\tpublic OptionalInt get" + prop.getUpperName() + "() {");
                list.add("\t\treturn " + prop.getFieldName() + " != null ? OptionalInt.of(" + prop.getFieldName() + ") : OptionalInt.empty();");
            } else if ("Long".equals(prop.getType())) {
                list.add("\tpublic OptionalLong get" + prop.getUpperName() + "() {");
                list.add("\t\treturn " + prop.getFieldName() + " != null ? OptionalLong.of(" + prop.getFieldName() + ") : OptionalLong.empty();");
            } else {
                list.add("\tpublic Optional<" + prop.getType() + "> get" + prop.getUpperName() + "() {");
                list.add("\t\treturn Optional.ofNullable(" + prop.getFieldName() + ");");
            }
            list.add("\t}");
            list.add("");
            return list;
        }

        @Override
        String generateGetInvoke(PropertyData prop) {
            return prop.getFieldName();
        }
    }

    static final class CloneCastGetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new CloneCastGetterGen("public ");
        static final GetterGen PROTECTED = new CloneCastGetterGen("protected ");
        static final GetterGen PACKAGE = new CloneCastGetterGen("");
        static final GetterGen PRIVATE = new CloneCastGetterGen("private ");
        private final String access;

        static GetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private CloneCastGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", "(" + prop.getFieldName() + " != null ? (" + prop.getFieldType() + ") " + prop.getFieldName() + ".clone() : null)");
        }
    }

    static final class CloneCastNNGetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new CloneCastNNGetterGen("public ");
        static final GetterGen PROTECTED = new CloneCastNNGetterGen("protected ");
        static final GetterGen PACKAGE = new CloneCastNNGetterGen("");
        static final GetterGen PRIVATE = new CloneCastNNGetterGen("private ");
        private final String access;

        static GetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private CloneCastNNGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", "(" + prop.getFieldType() + ") " + prop.getFieldName() + ".clone()");
        }
    }

    static final class CloneGetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new CloneGetterGen("public ");
        static final GetterGen PROTECTED = new CloneGetterGen("protected ");
        static final GetterGen PACKAGE = new CloneGetterGen("");
        static final GetterGen PRIVATE = new CloneGetterGen("private ");
        private final String access;

        static GetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private CloneGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", "(" + prop.getFieldName() + " != null ? " + prop.getFieldName() + ".clone() : null)");
        }
    }

    static final class CloneNNGetterGen
    extends GetterGen {
        static final GetterGen PUBLIC = new CloneNNGetterGen("public ");
        static final GetterGen PROTECTED = new CloneNNGetterGen("protected ");
        static final GetterGen PACKAGE = new CloneNNGetterGen("");
        static final GetterGen PRIVATE = new CloneNNGetterGen("private ");
        private final String access;

        static GetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private CloneNNGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", prop.getFieldName() + ".clone()");
        }
    }

    static final class IsGetterGen
    extends GetterGen {
        static final IsGetterGen PUBLIC = new IsGetterGen("public ");
        static final IsGetterGen PROTECTED = new IsGetterGen("protected ");
        static final IsGetterGen PACKAGE = new IsGetterGen("");
        static final IsGetterGen PRIVATE = new IsGetterGen("private ");
        private final String access;

        static IsGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private IsGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "is", prop.getFieldName());
        }

        @Override
        String generateGetInvoke(PropertyData prop) {
            return "is" + prop.getUpperName() + "()";
        }
    }

    static final class GetGetterGen
    extends GetterGen {
        static final GetGetterGen PUBLIC = new GetGetterGen("public ");
        static final GetGetterGen PROTECTED = new GetGetterGen("protected ");
        static final GetGetterGen PACKAGE = new GetGetterGen("");
        static final GetGetterGen PRIVATE = new GetGetterGen("private ");
        private final String access;

        static GetGetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private GetGetterGen(String access) {
            this.access = access;
        }

        @Override
        List<String> generateGetter(PropertyData prop) {
            return GetterGen.doGenerateGetter(prop, this.access, "get", prop.getFieldName());
        }
    }
}

