/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.beans.Bean;
import org.joda.beans.DynamicBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaBeanProvider;
import org.joda.beans.MetaProvider;
import org.joda.beans.impl.flexi.FlexiBean;
import org.joda.beans.impl.map.MapBean;

final class MetaBeans {
    private static final ConcurrentHashMap<Class<?>, MetaBean> META_BEANS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, MetaBeanProvider> META_BEAN_PROVIDERS = new ConcurrentHashMap();

    private MetaBeans() {
    }

    static MetaBean lookup(Class<?> cls) {
        MetaBean meta = META_BEANS.get(cls);
        if (meta == null) {
            return MetaBeans.metaBeanLookup(cls);
        }
        return meta;
    }

    private static MetaBean metaBeanLookup(Class<?> cls) {
        if (cls == FlexiBean.class) {
            return new FlexiBean().metaBean();
        }
        if (cls == MapBean.class) {
            return new MapBean().metaBean();
        }
        if (DynamicBean.class.isAssignableFrom(cls)) {
            try {
                return cls.asSubclass(DynamicBean.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).metaBean();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalArgumentException("Unable to find meta-bean for a DynamicBean: " + cls.getName(), ex);
            }
        }
        try {
            cls = Class.forName(cls.getName(), true, cls.getClassLoader());
        }
        catch (ClassNotFoundException | Error ex) {
            throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName(), ex);
        }
        MetaBean meta = META_BEANS.get(cls);
        if (meta != null) {
            return meta;
        }
        MetaProvider providerAnnotation = MetaBeans.findProviderAnnotation(cls);
        if (providerAnnotation != null) {
            Class<? extends MetaBeanProvider> providerClass = providerAnnotation.value();
            try {
                MetaBeanProvider provider = META_BEAN_PROVIDERS.get(providerClass);
                if (provider == null) {
                    provider = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    META_BEAN_PROVIDERS.put(providerClass, provider);
                }
                if ((meta = provider.findMetaBean(cls)) == null) {
                    throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName());
                }
                MetaBeans.register(meta);
                return meta;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create instance of " + providerClass.getName() + " to provide meta bean for " + cls.getName(), e);
            }
        }
        throw new IllegalArgumentException("Unable to find meta-bean: " + cls.getName());
    }

    private static MetaProvider findProviderAnnotation(Class<?> cls) {
        MetaProvider providerAnnotation = cls.getAnnotation(MetaProvider.class);
        if (providerAnnotation != null) {
            return providerAnnotation;
        }
        for (Class<?> implementedInterface : cls.getInterfaces()) {
            providerAnnotation = implementedInterface.getAnnotation(MetaProvider.class);
            if (providerAnnotation == null) continue;
            return providerAnnotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass.equals(Object.class)) {
            return null;
        }
        return MetaBeans.findProviderAnnotation(superclass);
    }

    static void register(MetaBean metaBean) {
        Class<? extends Bean> type = metaBean.beanType();
        if (META_BEANS.putIfAbsent(type, metaBean) != null) {
            throw new IllegalArgumentException("Cannot register class twice: " + type.getName());
        }
    }
}

