/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.joda.beans.gen.BuilderGen;
import org.joda.beans.gen.CopyGen;

public final class BeanGenConfig {
    private static final Charset UTF8 = (Charset)Charset.availableCharsets().get("UTF-8");
    private final Map<String, CopyGen> copyGenerators;
    private final Map<String, String> builderTypes;
    private final Map<String, BuilderGen> builderGenerators;
    private final Set<String> invalidImmutableTypes;
    private final Map<String, String> immutableVarArgs;
    private final Map<String, String> immutableGetClones;
    private String indent = "    ";
    private String prefix = "";
    private String eol = System.lineSeparator();
    private String defaultStyle = "smart";
    private boolean generatedAnno;

    public static BeanGenConfig parse(String resourceLocator) {
        String fullFile = resourceLocator.contains("/") || resourceLocator.endsWith(".ini") ? resourceLocator : (resourceLocator.equals("jdk6") ? "org/joda/beans/gen/jdk.ini" : "org/joda/beans/gen/" + resourceLocator + ".ini");
        ClassLoader loader = BeanGenConfig.class.getClassLoader();
        if (loader == null) {
            throw new IllegalArgumentException("ClassLoader was null: " + fullFile);
        }
        URL url = loader.getResource(fullFile);
        if (url == null) {
            throw new IllegalArgumentException("Configuration file not found: " + fullFile);
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(url.openStream(), UTF8));
            String line = in.readLine();
            while (line != null) {
                if (!line.trim().startsWith("#") && line.trim().length() > 0) {
                    lines.add(line);
                }
                line = in.readLine();
            }
            BeanGenConfig beanGenConfig = BeanGenConfig.parse(lines);
            return beanGenConfig;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static BeanGenConfig parse(List<String> lines) {
        HashMap<String, String> immutableCopiers = new HashMap<String, String>();
        HashMap<String, String> mutableCopiers = new HashMap<String, String>();
        HashMap<String, String> immutableGetClones = new HashMap<String, String>();
        HashMap<String, String> immutableVarArgs = new HashMap<String, String>();
        HashMap<String, String> builderInits = new HashMap<String, String>();
        HashMap<String, String> builderTypes = new HashMap<String, String>();
        HashSet<String> invalidImmutableTypes = new HashSet<String>();
        ListIterator<String> iterator = lines.listIterator();
        block0: while (iterator.hasNext()) {
            String value;
            String key;
            int n;
            Object line = iterator.next().trim();
            if (((String)line).equals("[immutable.builder.to.immutable]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    immutableCopiers.put(key, value);
                }
                continue;
            }
            if (((String)line).equals("[immutable.builder.to.mutable]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    mutableCopiers.put(key, value);
                }
                continue;
            }
            if (((String)line).equals("[immutable.invalid.type]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    invalidImmutableTypes.add(key);
                }
                continue;
            }
            if (((String)line).equals("[immutable.get.clone]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    if (!value.equals("clone") && !value.equals("cloneCast")) {
                        throw new IllegalArgumentException("Value for [immutable.get.clone] must be 'clone' or 'cloneCast'");
                    }
                    immutableGetClones.put(key, value);
                }
                continue;
            }
            if (((String)line).equals("[immutable.builder.varargs]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    immutableVarArgs.put(key, value);
                }
                continue;
            }
            if (((String)line).equals("[immutable.builder.type]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    builderTypes.put(key, value);
                }
                continue;
            }
            if (((String)line).equals("[immutable.builder.init]")) {
                while (iterator.hasNext()) {
                    line = iterator.next().trim();
                    if (((String)line).startsWith("[")) {
                        iterator.previous();
                        continue block0;
                    }
                    n = ((String)line).indexOf(61);
                    if (n <= 0) {
                        throw new IllegalArgumentException("Invalid ini file line: " + (String)line);
                    }
                    key = ((String)line).substring(0, n).trim();
                    value = ((String)line).substring(n + 1).trim();
                    builderInits.put(key, value);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid ini file section: " + (String)line);
        }
        HashMap<String, BuilderGen> builderGenerators = new HashMap<String, BuilderGen>();
        for (Map.Entry entry : builderInits.entrySet()) {
            String type = (String)builderTypes.get(entry.getKey());
            if (type == null) {
                type = (String)entry.getKey() + "<>";
            }
            builderGenerators.put((String)entry.getKey(), new BuilderGen.PatternBuilderGen(type, (String)entry.getValue()));
        }
        HashMap<String, CopyGen> copyGenerators = new HashMap<String, CopyGen>();
        for (Map.Entry entry : immutableCopiers.entrySet()) {
            String fieldType = (String)entry.getKey();
            String immutableCopier = (String)entry.getValue();
            String mutableCopier = (String)mutableCopiers.get(fieldType);
            if (mutableCopier == null) {
                throw new IllegalArgumentException("[immutable.builder.to.immutable] and [immutable.builder.to.mutable] entries must match: " + fieldType);
            }
            copyGenerators.put(fieldType, new CopyGen.PatternCopyGen(immutableCopier, mutableCopier));
        }
        return new BeanGenConfig(copyGenerators, builderGenerators, builderTypes, invalidImmutableTypes, immutableVarArgs, immutableGetClones);
    }

    private BeanGenConfig(Map<String, CopyGen> copyGenerators, Map<String, BuilderGen> builderGenerators, Map<String, String> builderTypes, Set<String> invalidImmutableTypes, Map<String, String> immutableVarArgs, Map<String, String> immutableGetClones) {
        this.copyGenerators = copyGenerators;
        this.builderGenerators = builderGenerators;
        this.builderTypes = builderTypes;
        this.invalidImmutableTypes = invalidImmutableTypes;
        this.immutableVarArgs = immutableVarArgs;
        this.immutableGetClones = immutableGetClones;
    }

    public Map<String, CopyGen> getCopyGenerators() {
        return this.copyGenerators;
    }

    public Map<String, BuilderGen> getBuilderGenerators() {
        return this.builderGenerators;
    }

    public Map<String, String> getBuilderTypes() {
        return this.builderTypes;
    }

    public Set<String> getInvalidImmutableTypes() {
        return this.invalidImmutableTypes;
    }

    public Map<String, String> getImmutableVarArgs() {
        return this.immutableVarArgs;
    }

    public Map<String, String> getImmutableGetClones() {
        return this.immutableGetClones;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getEol() {
        return this.eol;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public boolean isGeneratedAnno() {
        return this.generatedAnno;
    }

    public void setGeneratedAnno(boolean generatedAnno) {
        this.generatedAnno = generatedAnno;
    }
}

