/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import org.joda.beans.Bean;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.bin.JodaBeanReferencingBinReader;
import org.joda.beans.ser.bin.JodaBeanStandardBinReader;
import org.joda.beans.ser.bin.MsgPack;
import org.joda.beans.ser.bin.MsgPackVisualizer;

public class JodaBeanBinReader
extends MsgPack {
    private final JodaBeanSer settings;

    public static String visualize(byte[] input) {
        return new MsgPackVisualizer(input).visualizeData();
    }

    public JodaBeanBinReader(JodaBeanSer settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.settings = settings;
    }

    public Bean read(byte[] input) {
        return this.read(input, Bean.class);
    }

    public <T> T read(byte[] input, Class<T> rootType) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        return this.read(new ByteArrayInputStream(input), rootType);
    }

    public Bean read(InputStream input) {
        return this.read(input, Bean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(InputStream input, Class<T> rootType) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        if (rootType == null) {
            throw new NullPointerException("rootType");
        }
        DataInputStream dataInput = input instanceof DataInputStream ? (DataInputStream)input : new DataInputStream(input);
        try {
            try {
                T t = this.parseVersion(dataInput, rootType);
                return t;
            }
            finally {
                input.close();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T parseVersion(DataInputStream input, Class<T> declaredType) throws Exception {
        byte arrayByte = input.readByte();
        byte versionByte = input.readByte();
        switch (versionByte) {
            case 1: {
                if (arrayByte != -110) {
                    throw new IllegalArgumentException("Invalid binary data: Expected array with 2 elements, but was: 0x" + JodaBeanBinReader.toHex(arrayByte));
                }
                return new JodaBeanStandardBinReader(this.settings, input).read(declaredType);
            }
            case 2: {
                if (arrayByte != -108) {
                    throw new IllegalArgumentException("Invalid binary data: Expected array with 4 elements, but was: 0x" + JodaBeanBinReader.toHex(arrayByte));
                }
                return new JodaBeanReferencingBinReader(this.settings, input).read(declaredType);
            }
        }
        throw new IllegalArgumentException("Invalid binary data: Expected version 1 or 2, but was: 0x" + JodaBeanBinReader.toHex(versionByte));
    }
}

