/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.bin.AbstractBinReader;
import org.joda.beans.ser.bin.MsgPackInput;

class JodaBeanReferencingBinReader
extends AbstractBinReader {
    private String overrideBasePackage;
    private ClassInfo[] classes;
    private Map<Class<?>, ClassInfo> classMap;
    private Object[] refs;

    JodaBeanReferencingBinReader(JodaBeanSer settings, DataInputStream input) {
        super(settings, input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    <T> T read(Class<T> rootType) {
        try {
            try {
                T t = this.parseRemaining(rootType);
                return t;
            }
            finally {
                this.input.close();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    <T> T parseRemaining(Class<T> declaredType) throws Exception {
        this.overrideBasePackage = declaredType.getPackage().getName() + ".";
        this.parseClassDescriptions();
        Object parsed = this.parseObject(declaredType, null, null, null, true);
        return declaredType.cast(parsed);
    }

    private void parseClassDescriptions() throws Exception {
        int refCount = this.acceptInteger(this.input.readByte());
        if (refCount < 0) {
            throw new IllegalArgumentException("Invalid binary data: Expected count of references, but was: " + refCount);
        }
        this.refs = new Object[refCount];
        int classMapSize = this.acceptMap(this.input.readByte());
        this.classes = new ClassInfo[classMapSize];
        this.classMap = new HashMap(classMapSize);
        for (int position = 0; position < classMapSize; ++position) {
            ClassInfo classInfo;
            this.classes[position] = classInfo = this.parseClassInfo();
            this.classMap.put(classInfo.type, classInfo);
        }
    }

    private ClassInfo parseClassInfo() throws Exception {
        String className = this.acceptString(this.input.readByte());
        Class<?> type = SerTypeMapper.decodeType(className, this.settings, this.overrideBasePackage, null);
        int propertyCount = this.acceptArray(this.input.readByte());
        if (propertyCount < 0) {
            throw new IllegalArgumentException("Invalid binary data: Expected array with 0 to many elements, but was: " + propertyCount);
        }
        MetaProperty[] metaProperties = new MetaProperty[propertyCount];
        if (ImmutableBean.class.isAssignableFrom(type)) {
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(type);
            MetaBean metaBean = deser.findMetaBean(type);
            for (int i = 0; i < propertyCount; ++i) {
                String propertyName = this.acceptString(this.input.readByte());
                metaProperties[i] = deser.findMetaProperty(type, metaBean, propertyName);
            }
        } else if (propertyCount != 0) {
            throw new IllegalArgumentException("Invalid binary data: Found non immutable bean class that has meta properties defined: " + type.getName() + ", " + propertyCount + " properties");
        }
        return new ClassInfo(type, metaProperties);
    }

    private Object parseBean(int propertyCount, ClassInfo classInfo) {
        String propName = "";
        if (classInfo.metaProperties.length != propertyCount) {
            throw new IllegalArgumentException("Invalid binary data: Expected " + classInfo.metaProperties.length + " properties but was: " + propertyCount);
        }
        try {
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(classInfo.type);
            MetaBean metaBean = deser.findMetaBean(classInfo.type);
            BeanBuilder<?> builder = deser.createBuilder(classInfo.type, metaBean);
            for (MetaProperty metaProp : classInfo.metaProperties) {
                if (metaProp == null) {
                    MsgPackInput.skipObject(this.input);
                } else {
                    propName = metaProp.name();
                    Object value = this.parseObject(SerOptional.extractType(metaProp, classInfo.type), metaProp, classInfo.type, null, false);
                    Object wrappedValue = SerOptional.wrapValue(metaProp, classInfo.type, value);
                    if (wrappedValue != null) {
                        deser.setValue(builder, metaProp, wrappedValue);
                    }
                }
                propName = "";
            }
            return deser.build(classInfo.type, builder);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing bean: " + classInfo.type.getName() + "::" + propName + ", " + ex.getMessage(), ex);
        }
    }

    @Override
    Object parseObject(Class<?> declaredType, MetaProperty<?> metaProp, Class<?> beanType, SerIterable parentIterable, boolean rootType) throws Exception {
        int reference;
        byte nestedTypeByteTemp;
        byte typeByteTemp;
        Class effectiveType = declaredType;
        ClassInfo classInfo = null;
        String metaType = null;
        Integer ref = null;
        byte typeByte = this.input.readByte();
        while (JodaBeanReferencingBinReader.isMap(typeByte)) {
            this.input.mark(18);
            int mapSize = this.acceptMap(typeByte);
            if (mapSize > 0) {
                typeByteTemp = this.input.readByte();
                if (this.isIntExtension(typeByteTemp)) {
                    nestedTypeByteTemp = typeByteTemp;
                    typeByteTemp = this.input.readByte();
                    reference = this.acceptIntExtension(nestedTypeByteTemp);
                    if (typeByteTemp == 33) {
                        if (mapSize != 1) {
                            throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                        }
                        classInfo = this.classes[reference];
                        if (!declaredType.isAssignableFrom(classInfo.type)) {
                            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + classInfo.type.getName());
                        }
                        typeByte = this.input.readByte();
                        continue;
                    }
                    if (typeByteTemp == 34) {
                        if (mapSize != 1) {
                            throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                        }
                        Object value = this.refs[reference];
                        if (!(value instanceof String)) {
                            throw new IllegalArgumentException("Invalid binary data: Expected reference to meta type name, but was: " + reference + ", " + value);
                        }
                        metaType = (String)value;
                        typeByte = this.input.readByte();
                        continue;
                    }
                    if (typeByteTemp == 35) {
                        if (mapSize != 1) {
                            throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                        }
                        ref = reference;
                        if (ref < 0 || ref > this.refs.length) {
                            throw new IllegalArgumentException("Invalid binary data: Expected reference to position less than " + this.refs.length + ", but was: " + ref);
                        }
                        typeByte = this.input.readByte();
                        continue;
                    }
                    this.input.reset();
                    break;
                }
                if (typeByteTemp == -57) {
                    int size = this.input.readUnsignedByte();
                    typeByteTemp = this.input.readByte();
                    if (typeByteTemp != 34) {
                        throw new IllegalArgumentException("Invalid binary data: Expected meta information, but was: 0x" + JodaBeanReferencingBinReader.toHex(typeByteTemp));
                    }
                    if (mapSize != 1) {
                        throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                    }
                    metaType = this.acceptStringBytes(size);
                    typeByte = this.input.readByte();
                    continue;
                }
                if (JodaBeanReferencingBinReader.isMap(typeByteTemp)) {
                    mapSize = this.acceptMap(typeByteTemp);
                    typeByteTemp = this.input.readByte();
                    if (this.isIntExtension(typeByteTemp)) {
                        nestedTypeByteTemp = typeByteTemp;
                        typeByteTemp = this.input.readByte();
                        reference = this.acceptIntExtension(nestedTypeByteTemp);
                        if (typeByteTemp == 35) {
                            if (mapSize != 1) {
                                throw new IllegalArgumentException("Invalid binary data: Expected map size 1, but was: " + mapSize);
                            }
                            typeByteTemp = this.input.readByte();
                            if (typeByteTemp == -57) {
                                int size = this.input.readUnsignedByte();
                                typeByteTemp = this.input.readByte();
                                if (typeByteTemp != 34) {
                                    throw new IllegalArgumentException("Invalid binary data: Expected previous metatype, but was: 0x" + JodaBeanReferencingBinReader.toHex(typeByteTemp));
                                }
                                metaType = this.acceptStringBytes(size);
                                this.refs[reference] = metaType;
                                typeByte = this.input.readByte();
                                continue;
                            }
                            this.input.reset();
                            break;
                        }
                        this.input.reset();
                        break;
                    }
                    this.input.reset();
                    break;
                }
                this.input.reset();
                break;
            }
            this.input.reset();
            break;
        }
        if (JodaBeanReferencingBinReader.isArray(typeByte)) {
            this.input.mark(11);
            int arraySize = this.acceptArray(typeByte);
            if (arraySize > 0) {
                typeByteTemp = this.input.readByte();
                if (this.isIntExtension(typeByteTemp)) {
                    nestedTypeByteTemp = typeByteTemp;
                    typeByteTemp = this.input.readByte();
                    reference = this.acceptIntExtension(nestedTypeByteTemp);
                    if (typeByteTemp == 32) {
                        classInfo = this.classes[reference];
                        Object bean = this.parseBean(declaredType, rootType, classInfo, arraySize);
                        if (ref != null) {
                            this.refs[ref.intValue()] = bean;
                        }
                        return bean;
                    }
                    this.input.reset();
                } else {
                    this.input.reset();
                }
            } else {
                this.input.reset();
            }
        }
        if (this.isIntExtension(typeByte)) {
            this.input.mark(5);
            byte typeByteTemp2 = this.input.readByte();
            int reference2 = this.acceptIntExtension(typeByte);
            if (typeByteTemp2 != 36) {
                throw new IllegalArgumentException("Invalid binary data: Expected reference to previous object, but was: 0x" + JodaBeanReferencingBinReader.toHex(typeByteTemp2));
            }
            Object value = this.refs[reference2];
            if (value == null) {
                throw new IllegalArgumentException("Invalid binary data: Expected reference to previous object, but was null: " + reference2);
            }
            return value;
        }
        if (classInfo != null) {
            effectiveType = classInfo.type;
        }
        Object value = this.parseObject(metaProp, beanType, parentIterable, effectiveType, metaType, typeByte);
        if (ref != null) {
            this.refs[ref.intValue()] = value;
        }
        return value;
    }

    private Object parseObject(MetaProperty<?> metaProp, Class<?> beanType, SerIterable parentIterable, Class<?> effectiveType, String metaType, int typeByte) throws Exception {
        if (typeByte == -64) {
            return null;
        }
        if (Bean.class.isAssignableFrom(effectiveType)) {
            if (JodaBeanReferencingBinReader.isArray(typeByte)) {
                int arraySize = this.acceptArray(typeByte);
                return this.parseBean(arraySize, this.classMap.get(effectiveType));
            }
            return this.parseSimple(typeByte, effectiveType);
        }
        if (JodaBeanReferencingBinReader.isMap(typeByte) || JodaBeanReferencingBinReader.isArray(typeByte)) {
            SerIterable childIterable = null;
            if (metaType != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(metaType, this.settings, null);
            } else if (metaProp != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(metaProp, beanType);
            } else if (parentIterable != null) {
                childIterable = this.settings.getIteratorFactory().createIterable(parentIterable);
            }
            if (childIterable == null) {
                throw new IllegalArgumentException("Invalid binary data: Invalid metaType: " + metaType);
            }
            return this.parseIterable(typeByte, childIterable);
        }
        return this.parseSimple(typeByte, effectiveType);
    }

    private Object parseBean(Class<?> declaredType, boolean rootType, ClassInfo classInfo, int arraySize) {
        if (rootType) {
            if (!Bean.class.isAssignableFrom(classInfo.type)) {
                throw new IllegalArgumentException("Root type is not a Joda-Bean: " + classInfo.type.getName());
            }
            this.overrideBasePackage = classInfo.type.getPackage().getName() + ".";
        }
        if (!declaredType.isAssignableFrom(classInfo.type)) {
            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + classInfo.type.getName());
        }
        return this.parseBean(arraySize - 1, classInfo);
    }

    private boolean isIntExtension(int typeByte) {
        return typeByte == -44 || typeByte == -43 || typeByte == -42;
    }

    private int acceptIntExtension(int typeByte) throws IOException {
        if (typeByte == -44) {
            return this.input.readUnsignedByte();
        }
        if (typeByte == -43) {
            return this.input.readUnsignedShort();
        }
        if (typeByte == -42) {
            return this.input.readInt();
        }
        throw new IllegalArgumentException("Invalid binary data: Expected int extension type, but was: 0x" + JodaBeanReferencingBinReader.toHex(typeByte));
    }

    private static final class ClassInfo {
        private final Class<?> type;
        private final MetaProperty<?>[] metaProperties;

        private ClassInfo(Class<?> type, MetaProperty<?>[] metaProperties) {
            this.type = type;
            this.metaProperties = metaProperties;
        }

        public String toString() {
            return "ClassInfo{type=" + this.type + ", metaProperties=" + Arrays.toString(this.metaProperties) + '}';
        }
    }
}

