/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.ImmutableCell;
import org.joda.collect.grid.ImmutableGrid;

final class SingletonGrid<V>
extends ImmutableGrid<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int rowCount;
    private final int columnCount;
    private final ImmutableCell<V> cell;

    SingletonGrid(int rowCount, int columnCount, Grid.Cell<V> cell) {
        SingletonGrid.validateCounts(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cell = ImmutableCell.copyOf(cell).validateCounts(rowCount, columnCount);
    }

    SingletonGrid(int rowCount, int columnCount, int row, int column, V value) {
        SingletonGrid.validateCounts(rowCount, columnCount);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cell = ImmutableCell.of(row, column, value).validateCounts(rowCount, columnCount);
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(int row, int column) {
        return this.cell.equalRowColumn(row, column);
    }

    @Override
    public boolean containsValue(Object valueToFind) {
        return this.cell.equalValue(valueToFind);
    }

    @Override
    public V get(int row, int column) {
        return this.cell.equalRowColumn(row, column) ? (V)this.cell.getValue() : null;
    }

    @Override
    public Grid.Cell<V> cell(int row, int column) {
        return this.cell.equalRowColumn(row, column) ? this.cell : null;
    }

    @Override
    public ImmutableSet<Grid.Cell<V>> cells() {
        return ImmutableSet.of(this.cell);
    }

    @Override
    public ImmutableList<V> values() {
        return ImmutableList.of(this.cell.getValue());
    }
}

