/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.joda.collect.grid.Grid;

abstract class AbstractCell<V>
implements Grid.Cell<V> {
    private static final Comparator<Grid.Cell<?>> COMPARATOR = new Comparator<Grid.Cell<?>>(){

        @Override
        public int compare(Grid.Cell<?> cell1, Grid.Cell<?> cell2) {
            int cmp;
            int otherRow;
            int thisRow = cell1.getRow();
            int n = thisRow < (otherRow = cell2.getRow()) ? -1 : (cmp = thisRow > otherRow ? 1 : 0);
            if (cmp == 0) {
                int otherCol;
                int thisCol = cell1.getColumn();
                cmp = thisCol < (otherCol = cell2.getColumn()) ? -1 : (thisCol > otherCol ? 1 : 0);
            }
            return cmp;
        }
    };

    static final <R> Comparator<Grid.Cell<R>> comparator() {
        return COMPARATOR;
    }

    AbstractCell() {
    }

    @Override
    public boolean equalRowColumn(int row, int column) {
        return row == this.getRow() && column == this.getColumn();
    }

    @Override
    public boolean equalValue(Object value) {
        return Objects.equal((Object)value, this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Grid.Cell) {
            Grid.Cell other = (Grid.Cell)obj;
            return this.getRow() == other.getRow() && this.getColumn() == other.getColumn() && Objects.equal(this.getValue(), other.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getRow() ^ Integer.rotateLeft(this.getColumn(), 16) ^ this.getValue().hashCode();
    }

    public String toString() {
        return "(" + this.getRow() + "," + this.getColumn() + ")=" + this.getValue();
    }
}

