/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import java.io.Serializable;
import org.joda.collect.grid.AbstractCell;
import org.joda.collect.grid.Grid;

public final class ImmutableCell<V>
extends AbstractCell<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int row;
    private final int column;
    private final V value;

    public static <R> ImmutableCell<R> of(int row, int column, R value) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("Row must not be negative: " + row + " < 0");
        }
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column must not be negative: " + column + " < 0");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        return new ImmutableCell<R>(row, column, value);
    }

    public static <R> ImmutableCell<R> copyOf(Grid.Cell<? extends R> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell must not be null");
        }
        if (cell instanceof ImmutableCell) {
            ImmutableCell result = (ImmutableCell)cell;
            return result;
        }
        return ImmutableCell.of(cell.getRow(), cell.getColumn(), cell.getValue());
    }

    ImmutableCell(int row, int column, V value) {
        this.row = row;
        this.column = column;
        this.value = value;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    ImmutableCell<V> validateCounts(int rowCount, int columnCount) {
        if (this.row >= rowCount || this.column >= columnCount) {
            throw new IndexOutOfBoundsException("Invalid row-column: " + this.row + "," + this.column + " for grid " + rowCount + "x" + columnCount);
        }
        return this;
    }
}

