/*
 * Decompiled with CFR 0.152.
 */
package org.joda.collect.grid;

import org.joda.collect.grid.AbstractGrid;
import org.joda.collect.grid.DenseImmutableGrid;
import org.joda.collect.grid.EmptyGrid;
import org.joda.collect.grid.Grid;
import org.joda.collect.grid.SingletonGrid;
import org.joda.collect.grid.SparseImmutableGrid;

public abstract class ImmutableGrid<V>
extends AbstractGrid<V> {
    public static <R> ImmutableGrid<R> of() {
        return new EmptyGrid();
    }

    public static <R> ImmutableGrid<R> of(int rowCount, int columnCount) {
        return new EmptyGrid(rowCount, columnCount);
    }

    public static <R> ImmutableGrid<R> of(R value) {
        return new SingletonGrid<R>(1, 1, 0, 0, value);
    }

    public static <R> ImmutableGrid<R> of(int rowCount, int columnCount, int row, int column, R value) {
        return new SingletonGrid<R>(rowCount, columnCount, row, column, value);
    }

    public static <R> ImmutableGrid<R> copyOf(int rowCount, int columnCount, Grid.Cell<R> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("Cell must not be null");
        }
        return new SingletonGrid<R>(rowCount, columnCount, cell);
    }

    public static <R> ImmutableGrid<R> copyOf(int rowCount, int columnCount, Iterable<? extends Grid.Cell<R>> cells) {
        if (cells == null) {
            throw new IllegalArgumentException("Cells must not be null");
        }
        if (!cells.iterator().hasNext()) {
            return new EmptyGrid(rowCount, columnCount);
        }
        return new SparseImmutableGrid(rowCount, columnCount, cells);
    }

    public static <R> ImmutableGrid<R> copyOfDeriveCounts(Iterable<? extends Grid.Cell<R>> cells) {
        if (cells == null) {
            throw new IllegalArgumentException("Cells must not be null");
        }
        if (!cells.iterator().hasNext()) {
            return new EmptyGrid();
        }
        int rowCount = 0;
        int columnCount = 0;
        for (Grid.Cell<R> cell : cells) {
            rowCount = Math.max(rowCount, cell.getRow());
            columnCount = Math.max(columnCount, cell.getColumn());
        }
        return new SparseImmutableGrid(rowCount + 1, columnCount + 1, cells);
    }

    public static <R> ImmutableGrid<R> copyOf(Grid<R> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("Grid must not be null");
        }
        if (grid instanceof ImmutableGrid) {
            return (ImmutableGrid)grid;
        }
        ImmutableGrid.validateCounts(grid.rowCount(), grid.columnCount());
        if (grid.size() == 0) {
            return new EmptyGrid(grid.rowCount(), grid.columnCount());
        }
        if (grid.size() == 1) {
            Grid.Cell<R> cell = grid.cells().iterator().next();
            return new SingletonGrid<R>(grid.rowCount(), grid.columnCount(), cell);
        }
        if (grid.size() >= grid.rowCount() * grid.columnCount() / 2) {
            return DenseImmutableGrid.create(grid);
        }
        return new SparseImmutableGrid<R>(grid);
    }

    ImmutableGrid() {
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("Grid is read-only");
    }

    @Override
    @Deprecated
    public void put(int row, int column, V value) {
        throw new UnsupportedOperationException("Grid is read-only");
    }

    @Override
    @Deprecated
    public void putAll(Grid<? extends V> grid) {
        throw new UnsupportedOperationException("Grid is read-only");
    }

    @Override
    @Deprecated
    public boolean remove(int row, int column) {
        throw new UnsupportedOperationException("Grid is read-only");
    }
}

