/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.FromStringConverter;
import org.joda.convert.FromStringFactory;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.ToString;
import org.joda.convert.ToStringConverter;

public final class StringConvert {
    public static final StringConvert INSTANCE = new StringConvert();
    private static final StringConverter<?> CACHED_NULL = new StringConverter<Object>(){

        @Override
        public String convertToString(Object object) {
            return null;
        }

        @Override
        public Object convertFromString(Class<? extends Object> cls, String str) {
            return null;
        }
    };
    private final ConcurrentMap<Class<?>, StringConverter<?>> registered = new ConcurrentHashMap();

    public StringConvert() {
        this(true);
    }

    public StringConvert(boolean includeJdkConverters) {
        if (includeJdkConverters) {
            for (JDKStringConverter conv : JDKStringConverter.values()) {
                this.registered.put(conv.getType(), conv);
            }
            this.registered.put(Boolean.TYPE, JDKStringConverter.BOOLEAN);
            this.registered.put(Byte.TYPE, JDKStringConverter.BYTE);
            this.registered.put(Short.TYPE, JDKStringConverter.SHORT);
            this.registered.put(Integer.TYPE, JDKStringConverter.INTEGER);
            this.registered.put(Long.TYPE, JDKStringConverter.LONG);
            this.registered.put(Float.TYPE, JDKStringConverter.FLOAT);
            this.registered.put(Double.TYPE, JDKStringConverter.DOUBLE);
            this.registered.put(Character.TYPE, JDKStringConverter.CHARACTER);
            this.tryRegister("java.time.Instant", "parse");
            this.tryRegister("java.time.Duration", "parse");
            this.tryRegister("java.time.LocalDate", "parse");
            this.tryRegister("java.time.LocalTime", "parse");
            this.tryRegister("java.time.LocalDateTime", "parse");
            this.tryRegister("java.time.OffsetTime", "parse");
            this.tryRegister("java.time.OffsetDateTime", "parse");
            this.tryRegister("java.time.ZonedDateTime", "parse");
            this.tryRegister("java.time.Year", "parse");
            this.tryRegister("java.time.YearMonth", "parse");
            this.tryRegister("java.time.MonthDay", "parse");
            this.tryRegister("java.time.Period", "parse");
            this.tryRegister("java.time.ZoneOffset", "of");
            this.tryRegister("java.time.ZoneId", "of");
            this.tryRegister("org.threeten.bp.Instant", "parse");
            this.tryRegister("org.threeten.bp.Duration", "parse");
            this.tryRegister("org.threeten.bp.LocalDate", "parse");
            this.tryRegister("org.threeten.bp.LocalTime", "parse");
            this.tryRegister("org.threeten.bp.LocalDateTime", "parse");
            this.tryRegister("org.threeten.bp.OffsetTime", "parse");
            this.tryRegister("org.threeten.bp.OffsetDateTime", "parse");
            this.tryRegister("org.threeten.bp.ZonedDateTime", "parse");
            this.tryRegister("org.threeten.bp.Year", "parse");
            this.tryRegister("org.threeten.bp.YearMonth", "parse");
            this.tryRegister("org.threeten.bp.MonthDay", "parse");
            this.tryRegister("org.threeten.bp.Period", "parse");
            this.tryRegister("org.threeten.bp.ZoneOffset", "of");
            this.tryRegister("org.threeten.bp.ZoneId", "of");
            this.tryRegister("javax.time.Instant", "parse");
            this.tryRegister("javax.time.Duration", "parse");
            this.tryRegister("javax.time.calendar.LocalDate", "parse");
            this.tryRegister("javax.time.calendar.LocalTime", "parse");
            this.tryRegister("javax.time.calendar.LocalDateTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDate", "parse");
            this.tryRegister("javax.time.calendar.OffsetTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDateTime", "parse");
            this.tryRegister("javax.time.calendar.ZonedDateTime", "parse");
            this.tryRegister("javax.time.calendar.Year", "parse");
            this.tryRegister("javax.time.calendar.YearMonth", "parse");
            this.tryRegister("javax.time.calendar.MonthDay", "parse");
            this.tryRegister("javax.time.calendar.Period", "parse");
            this.tryRegister("javax.time.calendar.ZoneOffset", "of");
            this.tryRegister("javax.time.calendar.ZoneId", "of");
            this.tryRegister("javax.time.calendar.TimeZone", "of");
        }
    }

    private void tryRegister(String className, String fromStringMethodName) {
        try {
            Class<?> cls = this.getClass().getClassLoader().loadClass(className);
            this.registerMethods(cls, "toString", fromStringMethodName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> String convertToString(T object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        StringConverter<?> conv = this.findConverter(cls);
        return conv.convertToString(object);
    }

    public <T> String convertToString(Class<T> cls, T object) {
        if (object == null) {
            return null;
        }
        StringConverter<T> conv = this.findConverter(cls);
        return conv.convertToString(object);
    }

    public <T> T convertFromString(Class<T> cls, String str) {
        if (str == null) {
            return null;
        }
        StringConverter<T> conv = this.findConverter(cls);
        return conv.convertFromString(cls, str);
    }

    public <T> StringConverter<T> findConverter(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        StringConverter<T> conv = (StringConverter<T>)this.registered.get(cls);
        if (conv == CACHED_NULL) {
            throw new IllegalStateException("No registered converter found: " + cls);
        }
        if (conv == null) {
            conv = this.findAnnotationConverter(cls);
            if (conv == null) {
                this.registered.putIfAbsent(cls, CACHED_NULL);
                throw new IllegalStateException("No registered converter found: " + cls);
            }
            this.registered.putIfAbsent(cls, conv);
        }
        return conv;
    }

    private <T> StringConverter<T> findAnnotationConverter(Class<T> cls) {
        StringConverter conv = null;
        for (Class<T> loopCls = cls.getSuperclass(); loopCls != null && conv == null; loopCls = loopCls.getSuperclass()) {
            conv = (StringConverter)this.registered.get(loopCls);
            if (conv == null || conv == CACHED_NULL) continue;
            return conv;
        }
        for (Class<?> loopIfc : cls.getInterfaces()) {
            conv = (StringConverter)this.registered.get(loopIfc);
            if (conv == null || conv == CACHED_NULL) continue;
            return conv;
        }
        conv = this.findAnnotatedConverter(cls);
        if (conv != null) {
            return conv;
        }
        return null;
    }

    private <T> StringConverter<T> findAnnotatedConverter(Class<T> cls) {
        Method toString = this.findToStringMethod(cls);
        if (toString == null) {
            return null;
        }
        Constructor<T> con = this.findFromStringConstructor(cls);
        Method fromString = this.findFromStringMethod(cls, con == null);
        if (con == null && fromString == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString: " + cls.getName());
        }
        if (con != null && fromString != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString: " + cls.getName());
        }
        if (con != null) {
            return new MethodConstructorStringConverter<T>(cls, toString, con);
        }
        return new MethodsStringConverter<T>(cls, toString, fromString);
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = loopCls.getDeclaredMethods()) {
                ToString toString = method.getAnnotation(ToString.class);
                if (toString == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString: " + cls.getName());
                }
                matched = method;
            }
        }
        if (matched == null) {
            for (Class<?> loopIfc : cls.getInterfaces()) {
                Method[] methods;
                for (Method method : methods = loopIfc.getDeclaredMethods()) {
                    ToString toString = method.getAnnotation(ToString.class);
                    if (toString == null) continue;
                    if (matched != null) {
                        throw new IllegalStateException("Two methods are annotated with @ToString on interfaces: " + cls.getName());
                    }
                    matched = method;
                }
            }
        }
        return matched;
    }

    private <T> Constructor<T> findFromStringConstructor(Class<T> cls) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString = con.getAnnotation(FromString.class);
        return fromString != null ? con : null;
    }

    private Method findFromStringMethod(Class<?> cls, boolean searchSuperclasses) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            matched = this.findFromString(loopCls, matched);
            if (!searchSuperclasses) break;
        }
        if (searchSuperclasses && matched == null) {
            for (Class<?> loopIfc : cls.getInterfaces()) {
                matched = this.findFromString(loopIfc, matched);
            }
        }
        return matched;
    }

    private Method findFromString(Class<?> cls, Method matched) {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            FromString fromString = method.getAnnotation(FromString.class);
            if (fromString == null) continue;
            if (matched != null) {
                throw new IllegalStateException("Two methods are annotated with @FromString: " + cls.getName());
            }
            matched = method;
        }
        FromStringFactory factory = cls.getAnnotation(FromStringFactory.class);
        if (factory != null) {
            Method[] factoryMethods;
            if (matched != null) {
                throw new IllegalStateException("Class annotated with @FromString and @FromStringFactory: " + cls.getName());
            }
            for (Method method : factoryMethods = factory.factory().getDeclaredMethods()) {
                FromString fromString;
                if (!cls.isAssignableFrom(method.getReturnType()) || (fromString = method.getAnnotation(FromString.class)) == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @FromString on the factory: " + factory.factory().getName());
                }
                matched = method;
            }
        }
        return matched;
    }

    public <T> void register(Class<T> cls, StringConverter<T> converter) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        this.registered.put(cls, converter);
    }

    public <T> void register(Class<T> cls, final ToStringConverter<T> toString, final FromStringConverter<T> fromString) {
        if (fromString == null || toString == null) {
            throw new IllegalArgumentException("Converters must not be null");
        }
        this.register(cls, new StringConverter<T>(){

            @Override
            public String convertToString(T object) {
                return toString.convertToString(object);
            }

            @Override
            public T convertFromString(Class<? extends T> cls, String str) {
                return fromString.convertFromString(cls, str);
            }
        });
    }

    public <T> void registerMethods(Class<T> cls, String toStringMethodName, String fromStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null || fromStringMethodName == null) {
            throw new IllegalArgumentException("Method names must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Method fromString = this.findFromStringMethod(cls, fromStringMethodName);
        MethodsStringConverter<T> converter = new MethodsStringConverter<T>(cls, toString, fromString);
        this.registered.putIfAbsent(cls, converter);
    }

    public <T> void registerMethodConstructor(Class<T> cls, String toStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Constructor<T> fromString = this.findFromStringConstructorByType(cls);
        MethodConstructorStringConverter<T> converter = new MethodConstructorStringConverter<T>(cls, toString, fromString);
        this.registered.putIfAbsent(cls, converter);
    }

    private Method findToStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must not be static: " + methodName);
        }
        return m;
    }

    private Method findFromStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = cls.getMethod(methodName, CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Method not found", ex2);
            }
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + methodName);
        }
        return m;
    }

    private <T> Constructor<T> findFromStringConstructorByType(Class<T> cls) {
        try {
            return cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                return cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Constructor not found", ex2);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

