/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.convert.AnnotationStringConverterFactory;
import org.joda.convert.ConstructorFromStringConverter;
import org.joda.convert.EnumStringConverterFactory;
import org.joda.convert.FromStringConverter;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodFromStringConverter;
import org.joda.convert.ReflectionStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ThreeTenBpStringConverter;
import org.joda.convert.ToStringConverter;
import org.joda.convert.TypeStringConverterFactory;
import org.joda.convert.TypeTokenStringConverter;
import org.joda.convert.TypedAdapter;
import org.joda.convert.TypedFromStringConverter;
import org.joda.convert.TypedStringConverter;
import org.joda.convert.factory.BooleanArrayStringConverterFactory;
import org.joda.convert.factory.BooleanObjectArrayStringConverterFactory;
import org.joda.convert.factory.ByteObjectArrayStringConverterFactory;
import org.joda.convert.factory.CharObjectArrayStringConverterFactory;
import org.joda.convert.factory.NumericArrayStringConverterFactory;
import org.joda.convert.factory.NumericObjectArrayStringConverterFactory;

public final class StringConvert {
    static final boolean LOG;
    private static final TypedStringConverter<?> CACHED_NULL;
    public static final StringConvert INSTANCE;
    private final CopyOnWriteArrayList<StringConverterFactory> factories = new CopyOnWriteArrayList();
    private final ConcurrentMap<Class<?>, TypedStringConverter<?>> registered = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, TypedFromStringConverter<?>> fromStrings = new ConcurrentHashMap();

    public static StringConvert create() {
        return new StringConvert(true, NumericArrayStringConverterFactory.INSTANCE, NumericObjectArrayStringConverterFactory.INSTANCE, CharObjectArrayStringConverterFactory.INSTANCE, ByteObjectArrayStringConverterFactory.INSTANCE, BooleanArrayStringConverterFactory.INSTANCE, BooleanObjectArrayStringConverterFactory.INSTANCE);
    }

    public StringConvert() {
        this(true, new StringConverterFactory[0]);
    }

    public StringConvert(boolean includeJdkConverters, StringConverterFactory ... factories) {
        if (factories == null) {
            throw new IllegalArgumentException("StringConverterFactory array must not be null");
        }
        for (StringConverterFactory factory : factories) {
            if (factory != null) continue;
            throw new IllegalArgumentException("StringConverterFactory array must not contain a null element");
        }
        if (includeJdkConverters) {
            for (JDKStringConverter conv : JDKStringConverter.values()) {
                this.registered.put(conv.getEffectiveType(), conv);
            }
            this.registered.put(Boolean.TYPE, JDKStringConverter.BOOLEAN);
            this.registered.put(Byte.TYPE, JDKStringConverter.BYTE);
            this.registered.put(Short.TYPE, JDKStringConverter.SHORT);
            this.registered.put(Integer.TYPE, JDKStringConverter.INTEGER);
            this.registered.put(Long.TYPE, JDKStringConverter.LONG);
            this.registered.put(Float.TYPE, JDKStringConverter.FLOAT);
            this.registered.put(Double.TYPE, JDKStringConverter.DOUBLE);
            this.registered.put(Character.TYPE, JDKStringConverter.CHARACTER);
            this.tryRegisterGuava();
            this.tryRegisterZoneSubclasses();
            this.tryRegisterThreeTenBackport();
        }
        if (factories.length > 0) {
            this.factories.addAll(Arrays.asList(factories));
        }
        this.factories.add(AnnotationStringConverterFactory.INSTANCE);
        if (includeJdkConverters) {
            this.factories.add(EnumStringConverterFactory.INSTANCE);
            this.factories.add(TypeStringConverterFactory.INSTANCE);
        }
    }

    private void tryRegisterGuava() {
        block2: {
            try {
                TypeTokenStringConverter conv = new TypeTokenStringConverter();
                this.registered.put(conv.getEffectiveType(), conv);
            }
            catch (Throwable ex) {
                if (!LOG) break block2;
                System.err.println("Joda-Convert: Unable to register Guava: " + String.valueOf(ex));
            }
        }
    }

    private void tryRegisterZoneSubclasses() {
        block11: {
            Serializable zone;
            block10: {
                block9: {
                    block8: {
                        try {
                            this.registered.put(SimpleTimeZone.class, JDKStringConverter.TIME_ZONE);
                        }
                        catch (Throwable ex) {
                            if (!LOG) break block8;
                            System.err.println("Joda-Convert: Error registering SimpleTimeZone: " + String.valueOf(ex));
                        }
                    }
                    try {
                        zone = TimeZone.getDefault();
                        this.registered.put(zone.getClass(), JDKStringConverter.TIME_ZONE);
                    }
                    catch (Throwable ex) {
                        if (!LOG) break block9;
                        System.err.println("Joda-Convert: Error registering TimeZone.getDefault(): " + String.valueOf(ex));
                    }
                }
                try {
                    zone = TimeZone.getTimeZone("Europe/London");
                    this.registered.put(zone.getClass(), JDKStringConverter.TIME_ZONE);
                }
                catch (Throwable ex) {
                    if (!LOG) break block10;
                    System.err.println("Joda-Convert: Error registering TimeZone.getTimeZone(zoneId): " + String.valueOf(ex));
                }
            }
            try {
                zone = ZoneId.of("Europe/London");
                this.registered.put(zone.getClass(), JDKStringConverter.ZONE_ID);
            }
            catch (Throwable ex) {
                if (!LOG) break block11;
                System.err.println("Joda-Convert: Error registering ZoneId.of(zoneId): " + String.valueOf(ex));
            }
        }
    }

    private void tryRegisterThreeTenBackport() {
        block3: {
            try {
                for (ThreeTenBpStringConverter conv : ThreeTenBpStringConverter.values()) {
                    this.registered.put(conv.getEffectiveType(), conv);
                }
                org.threeten.bp.ZoneId zone = org.threeten.bp.ZoneId.of((String)"Europe/London");
                this.registered.put(zone.getClass(), ThreeTenBpStringConverter.ZONE_ID);
            }
            catch (Throwable ex) {
                if (!LOG) break block3;
                System.err.println("Joda-Convert: Unable to register ThreeTen-Backport: " + String.valueOf(ex));
            }
        }
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        StringConverter<Object> conv = this.findConverterNoGenerics(cls);
        return conv.convertToString(object);
    }

    public String convertToString(Class<?> cls, Object object) {
        if (object == null) {
            return null;
        }
        StringConverter<Object> conv = this.findConverterNoGenerics(cls);
        return conv.convertToString(object);
    }

    public <T> T convertFromString(Class<T> cls, String str) {
        if (str == null) {
            return null;
        }
        FromStringConverter<T> conv = this.findFromStringConverter(cls);
        return conv.convertFromString(cls, str);
    }

    public boolean isConvertible(Class<?> cls) {
        try {
            return cls != null && this.findConverterQuiet(cls) != null;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    public <T> Optional<TypedStringConverter<T>> converterFor(Class<T> cls) {
        return Optional.ofNullable(this.findConverterQuiet(cls));
    }

    public <T> Optional<TypedFromStringConverter<T>> fromStringConverterFor(Class<T> cls) {
        TypedStringConverter<T> converter = this.findConverterQuiet(cls);
        if (converter == null) {
            TypedFromStringConverter fromStringConverter = (TypedFromStringConverter)this.fromStrings.get(cls);
            return fromStringConverter == CACHED_NULL ? Optional.empty() : Optional.of(fromStringConverter);
        }
        return Optional.of(converter);
    }

    public <T> StringConverter<T> findConverter(Class<T> cls) {
        return this.findTypedConverter(cls);
    }

    public StringConverter<Object> findConverterNoGenerics(Class<?> cls) {
        return this.findTypedConverterNoGenerics(cls);
    }

    public <T> TypedStringConverter<T> findTypedConverter(Class<T> cls) {
        TypedStringConverter<T> conv = this.findConverterQuiet(cls);
        if (conv == null) {
            throw new IllegalStateException("No registered converter found: " + String.valueOf(cls));
        }
        return conv;
    }

    public TypedStringConverter<Object> findTypedConverterNoGenerics(Class<?> cls) {
        TypedStringConverter<Object> conv = this.findConverterQuiet(cls);
        if (conv == null) {
            throw new IllegalStateException("No registered converter found: " + String.valueOf(cls));
        }
        return conv;
    }

    public <T> FromStringConverter<T> findFromStringConverter(Class<T> cls) {
        return this.fromStringConverterFor(cls).orElseThrow(() -> new IllegalStateException("No registered converter found: " + String.valueOf(cls)));
    }

    private <T> TypedStringConverter<T> findConverterQuiet(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        TypedStringConverter<T> conv = (TypedStringConverter<T>)this.registered.get(cls);
        if (conv == CACHED_NULL) {
            return null;
        }
        if (conv == null) {
            try {
                conv = this.lookupConverter(cls);
            }
            catch (RuntimeException ex) {
                this.registered.putIfAbsent(cls, CACHED_NULL);
                throw ex;
            }
            if (conv == null) {
                this.registered.putIfAbsent(cls, CACHED_NULL);
                this.fromStrings.computeIfAbsent(cls, key -> {
                    TypedFromStringConverter fromString = AnnotationStringConverterFactory.INSTANCE.findFromStringConverter(cls);
                    return fromString != null ? fromString : CACHED_NULL;
                });
                return null;
            }
            this.registered.putIfAbsent(cls, conv);
        }
        return conv;
    }

    private <T> TypedStringConverter<T> lookupConverter(Class<T> cls) {
        for (StringConverterFactory factory : this.factories) {
            StringConverter<?> factoryConv = factory.findConverter(cls);
            if (factoryConv == null) continue;
            return TypedAdapter.adapt(cls, factoryConv);
        }
        return null;
    }

    public void registerFactory(StringConverterFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        this.factories.add(0, factory);
    }

    public <T> void register(Class<T> cls, StringConverter<T> converter) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        this.registered.put(cls, TypedAdapter.adapt(cls, converter));
    }

    public <T> void register(final Class<T> cls, final ToStringConverter<T> toString, final FromStringConverter<T> fromString) {
        if (fromString == null || toString == null) {
            throw new IllegalArgumentException("Converters must not be null");
        }
        this.register(cls, new TypedStringConverter<T>(){

            @Override
            public String convertToString(T object) {
                return toString.convertToString(object);
            }

            @Override
            public T convertFromString(Class<? extends T> cls2, String str) {
                return fromString.convertFromString(cls2, str);
            }

            @Override
            public Class<?> getEffectiveType() {
                return cls;
            }
        });
    }

    public <T> void registerMethods(Class<T> cls, String toStringMethodName, String fromStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null || fromStringMethodName == null) {
            throw new IllegalArgumentException("Method names must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Method fromString = this.findFromStringMethod(cls, fromStringMethodName);
        MethodFromStringConverter<T> fromStringConverter = new MethodFromStringConverter<T>(cls, fromString, cls);
        ReflectionStringConverter<T> converter = new ReflectionStringConverter<T>(cls, toString, fromStringConverter);
        this.registered.putIfAbsent(cls, converter);
    }

    public <T> void registerMethodConstructor(Class<T> cls, String toStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Constructor<T> fromString = this.findFromStringConstructorByType(cls);
        ConstructorFromStringConverter<T> fromStringConverter = new ConstructorFromStringConverter<T>(cls, fromString);
        ReflectionStringConverter<T> converter = new ReflectionStringConverter<T>(cls, toString, fromStringConverter);
        this.registered.putIfAbsent(cls, converter);
    }

    private Method findToStringMethod(Class<?> cls, String methodName) {
        try {
            Method m = cls.getMethod(methodName, new Class[0]);
            if (Modifier.isStatic(m.getModifiers())) {
                throw new IllegalArgumentException("Method must not be static: " + methodName);
            }
            return m;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private Method findFromStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = cls.getMethod(methodName, CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Method not found", ex2);
            }
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + methodName);
        }
        return m;
    }

    private <T> Constructor<T> findFromStringConstructorByType(Class<T> cls) {
        try {
            return cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                return cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Constructor not found", ex2);
            }
        }
    }

    static Class<?> loadType(String fullName) throws ClassNotFoundException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader != null && !fullName.startsWith("[") ? loader.loadClass(fullName) : Class.forName(fullName);
        }
        catch (ClassNotFoundException ex) {
            return StringConvert.loadPrimitiveType(fullName, ex);
        }
    }

    private static Class<?> loadPrimitiveType(String fullName, ClassNotFoundException ex) throws ClassNotFoundException {
        if (fullName.equals("int")) {
            return Integer.TYPE;
        }
        if (fullName.equals("long")) {
            return Long.TYPE;
        }
        if (fullName.equals("double")) {
            return Double.TYPE;
        }
        if (fullName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (fullName.equals("short")) {
            return Short.TYPE;
        }
        if (fullName.equals("byte")) {
            return Byte.TYPE;
        }
        if (fullName.equals("char")) {
            return Character.TYPE;
        }
        if (fullName.equals("float")) {
            return Float.TYPE;
        }
        if (fullName.equals("void")) {
            return Void.TYPE;
        }
        throw ex;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        String log = null;
        try {
            log = System.getProperty("org.joda.convert.debug");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LOG = "true".equalsIgnoreCase(log);
        CACHED_NULL = new TypedStringConverter<Object>(){

            @Override
            public String convertToString(Object object) {
                return null;
            }

            @Override
            public Object convertFromString(Class<? extends Object> cls, String str) {
                return null;
            }

            @Override
            public Class<?> getEffectiveType() {
                return null;
            }
        };
        INSTANCE = new StringConvert();
    }
}

