/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.collection.BooleanCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.BooleanIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBooleanCollection
extends AbstractPrimitiveCollectable<Boolean>
implements BooleanCollection {
    protected AbstractBooleanCollection() {
    }

    @Override
    public boolean contains(boolean bl) {
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.nextBoolean() != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(boolean[] blArray) {
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                if (this.contains(blArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanCollection booleanCollection) {
        if (booleanCollection != null) {
            BooleanIterator booleanIterator = booleanCollection.iterator();
            while (booleanIterator.hasNext()) {
                if (this.contains(booleanIterator.nextBoolean())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAny(boolean[] blArray) {
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!this.contains(blArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(BooleanCollection booleanCollection) {
        if (booleanCollection != null) {
            BooleanIterator booleanIterator = booleanCollection.iterator();
            while (booleanIterator.hasNext()) {
                if (!this.contains(booleanIterator.nextBoolean())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean[] toBooleanArray() {
        if (this.size() == 0) {
            return BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[this.size()];
        this.arrayCopy(0, blArray, 0, this.size());
        return blArray;
    }

    @Override
    public boolean[] toBooleanArray(boolean[] blArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        boolean[] blArray2 = null;
        if (blArray == null) {
            blArray2 = new boolean[n + this.size()];
        } else if (blArray.length - n - this.size() >= 0) {
            blArray2 = blArray;
        } else {
            blArray2 = new boolean[n + this.size()];
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        this.arrayCopy(0, blArray2, n, this.size());
        return blArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            booleanIterator.nextBoolean();
            booleanIterator.remove();
        }
    }

    @Override
    public boolean add(boolean bl) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(boolean[] blArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                bl |= this.add(blArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(BooleanCollection booleanCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (booleanCollection != null) {
            BooleanIterator booleanIterator = booleanCollection.iterator();
            while (booleanIterator.hasNext()) {
                bl |= this.add(booleanIterator.nextBoolean());
            }
        }
        return bl;
    }

    @Override
    public boolean removeFirst(boolean bl) {
        this.checkRemoveModifiable();
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.nextBoolean() != bl) continue;
            booleanIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(boolean bl) {
        this.checkRemoveModifiable();
        boolean bl2 = false;
        BooleanIterator booleanIterator = this.iterator();
        while (booleanIterator.hasNext()) {
            if (booleanIterator.nextBoolean() != bl) continue;
            booleanIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(boolean[] blArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (blArray != null) {
            BooleanIterator booleanIterator = this.iterator();
            while (booleanIterator.hasNext()) {
                boolean bl2 = booleanIterator.nextBoolean();
                for (int i = 0; i < blArray.length; ++i) {
                    if (blArray[i] != bl2) continue;
                    booleanIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(BooleanCollection booleanCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (booleanCollection != null) {
            BooleanIterator booleanIterator = this.iterator();
            while (booleanIterator.hasNext()) {
                if (!booleanCollection.contains(booleanIterator.nextBoolean())) continue;
                booleanIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(boolean[] blArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (blArray == null || blArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            BooleanIterator booleanIterator = this.iterator();
            while (booleanIterator.hasNext()) {
                boolean bl2 = booleanIterator.nextBoolean();
                boolean bl3 = false;
                for (int i = 0; i < blArray.length; ++i) {
                    if (blArray[i] != bl2) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                booleanIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(BooleanCollection booleanCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (booleanCollection == null || booleanCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            BooleanIterator booleanIterator = this.iterator();
            while (booleanIterator.hasNext()) {
                if (booleanCollection.contains(booleanIterator.nextBoolean())) continue;
                booleanIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Boolean[this.size()];
        BooleanIterator booleanIterator = this.iterator();
        int n = 0;
        while (booleanIterator.hasNext()) {
            objectArray[n] = booleanIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        BooleanIterator booleanIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = booleanIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Boolean bl) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(bl));
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        BooleanIterator booleanIterator = this.iterator();
        boolean bl = booleanIterator.hasNext();
        while (bl) {
            stringBuffer.append(booleanIterator.nextBoolean());
            bl = booleanIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, boolean[] blArray, int n2, int n3) {
        BooleanIterator booleanIterator = this.iterator();
        for (int i = 0; booleanIterator.hasNext() && i < n3; ++i) {
            blArray[n2 + i] = booleanIterator.nextBoolean();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Boolean toObject(boolean bl) {
        return BooleanUtils.toObject(bl);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Boolean;
    }

    protected boolean toPrimitive(Object object) {
        return BooleanUtils.toPrimitive(object);
    }

    protected boolean[] toPrimitiveArray(Collection<?> collection) {
        return BooleanUtils.toPrimitiveArray(collection);
    }
}

