/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.collection.ByteCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.ByteIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteCollection
extends AbstractPrimitiveCollectable<Byte>
implements ByteCollection {
    protected AbstractByteCollection() {
    }

    @Override
    public boolean contains(byte by) {
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.nextByte() != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(byte[] byArray) {
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                if (this.contains(byArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteCollection byteCollection) {
        if (byteCollection != null) {
            ByteIterator byteIterator = byteCollection.iterator();
            while (byteIterator.hasNext()) {
                if (this.contains(byteIterator.nextByte())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(byte by, byte by2) {
        if (by > by2) {
            return true;
        }
        for (byte by3 = by; by3 <= by2; by3 = (byte)(by3 + 1)) {
            if (this.contains(by3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(byte[] byArray) {
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                if (!this.contains(byArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(ByteCollection byteCollection) {
        if (byteCollection != null) {
            ByteIterator byteIterator = byteCollection.iterator();
            while (byteIterator.hasNext()) {
                if (!this.contains(byteIterator.nextByte())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(byte by, byte by2) {
        if (by > by2) {
            return false;
        }
        for (byte by3 = by; by3 <= by2; by3 = (byte)(by3 + 1)) {
            if (!this.contains(by3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] toByteArray() {
        if (this.size() == 0) {
            return ByteUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[this.size()];
        this.arrayCopy(0, byArray, 0, this.size());
        return byArray;
    }

    @Override
    public byte[] toByteArray(byte[] byArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        byte[] byArray2 = null;
        if (byArray == null) {
            byArray2 = new byte[n + this.size()];
        } else if (byArray.length - n - this.size() >= 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n + this.size()];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        this.arrayCopy(0, byArray2, n, this.size());
        return byArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byteIterator.nextByte();
            byteIterator.remove();
        }
    }

    @Override
    public boolean add(byte by) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(byte[] byArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                bl |= this.add(byArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(ByteCollection byteCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (byteCollection != null) {
            ByteIterator byteIterator = byteCollection.iterator();
            while (byteIterator.hasNext()) {
                bl |= this.add(byteIterator.nextByte());
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(byte by, byte by2) {
        this.checkAddModifiable();
        if (by > by2) {
            return false;
        }
        boolean bl = false;
        for (byte by3 = by; by3 <= by2; by3 = (byte)(by3 + 1)) {
            bl |= this.add(by3);
        }
        return false;
    }

    @Override
    public boolean removeFirst(byte by) {
        this.checkRemoveModifiable();
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.nextByte() != by) continue;
            byteIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(byte by) {
        this.checkRemoveModifiable();
        boolean bl = false;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            if (byteIterator.nextByte() != by) continue;
            byteIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(byte[] byArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (byArray != null) {
            ByteIterator byteIterator = this.iterator();
            while (byteIterator.hasNext()) {
                byte by = byteIterator.nextByte();
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != by) continue;
                    byteIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(ByteCollection byteCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (byteCollection != null) {
            ByteIterator byteIterator = this.iterator();
            while (byteIterator.hasNext()) {
                if (!byteCollection.contains(byteIterator.nextByte())) continue;
                byteIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(byte by, byte by2) {
        this.checkRemoveModifiable();
        if (by > by2) {
            return false;
        }
        boolean bl = false;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byte by3 = byteIterator.nextByte();
            if (by3 < by || by3 > by2) continue;
            byteIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(byte[] byArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (byArray == null || byArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            ByteIterator byteIterator = this.iterator();
            while (byteIterator.hasNext()) {
                byte by = byteIterator.nextByte();
                boolean bl2 = false;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != by) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                byteIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(ByteCollection byteCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (byteCollection == null || byteCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            ByteIterator byteIterator = this.iterator();
            while (byteIterator.hasNext()) {
                if (byteCollection.contains(byteIterator.nextByte())) continue;
                byteIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(byte by, byte by2) {
        this.checkRemoveModifiable();
        boolean bl = false;
        ByteIterator byteIterator = this.iterator();
        while (byteIterator.hasNext()) {
            byte by3 = byteIterator.nextByte();
            if (by3 >= by && by3 <= by2) continue;
            byteIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Byte[this.size()];
        ByteIterator byteIterator = this.iterator();
        int n = 0;
        while (byteIterator.hasNext()) {
            objectArray[n] = byteIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        ByteIterator byteIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = byteIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Byte by) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(by));
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        ByteIterator byteIterator = this.iterator();
        boolean bl = byteIterator.hasNext();
        while (bl) {
            stringBuffer.append(byteIterator.nextByte());
            bl = byteIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, byte[] byArray, int n2, int n3) {
        ByteIterator byteIterator = this.iterator();
        for (int i = 0; byteIterator.hasNext() && i < n3; ++i) {
            byArray[n2 + i] = byteIterator.nextByte();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Byte toObject(byte by) {
        return ByteUtils.toObject(by);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Byte;
    }

    protected byte toPrimitive(Object object) {
        return ByteUtils.toPrimitive(object);
    }

    protected byte[] toPrimitiveArray(Collection<?> collection) {
        return ByteUtils.toPrimitiveArray(collection);
    }
}

