/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.CharUtils;
import org.joda.primitives.collection.CharCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.CharIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharCollection
extends AbstractPrimitiveCollectable<Character>
implements CharCollection {
    protected AbstractCharCollection() {
    }

    @Override
    public boolean contains(char c) {
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.nextChar() != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(char[] cArray) {
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                if (this.contains(cArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(CharCollection charCollection) {
        if (charCollection != null) {
            CharIterator charIterator = charCollection.iterator();
            while (charIterator.hasNext()) {
                if (this.contains(charIterator.nextChar())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(char c, char c2) {
        if (c > c2) {
            return true;
        }
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            if (this.contains(c3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(char[] cArray) {
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                if (!this.contains(cArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(CharCollection charCollection) {
        if (charCollection != null) {
            CharIterator charIterator = charCollection.iterator();
            while (charIterator.hasNext()) {
                if (!this.contains(charIterator.nextChar())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(char c, char c2) {
        if (c > c2) {
            return false;
        }
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            if (!this.contains(c3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public char[] toCharArray() {
        if (this.size() == 0) {
            return CharUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[this.size()];
        this.arrayCopy(0, cArray, 0, this.size());
        return cArray;
    }

    @Override
    public char[] toCharArray(char[] cArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        char[] cArray2 = null;
        if (cArray == null) {
            cArray2 = new char[n + this.size()];
        } else if (cArray.length - n - this.size() >= 0) {
            cArray2 = cArray;
        } else {
            cArray2 = new char[n + this.size()];
            System.arraycopy(cArray, 0, cArray2, 0, n);
        }
        this.arrayCopy(0, cArray2, n, this.size());
        return cArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            charIterator.nextChar();
            charIterator.remove();
        }
    }

    @Override
    public boolean add(char c) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(char[] cArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                bl |= this.add(cArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(CharCollection charCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (charCollection != null) {
            CharIterator charIterator = charCollection.iterator();
            while (charIterator.hasNext()) {
                bl |= this.add(charIterator.nextChar());
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(char c, char c2) {
        this.checkAddModifiable();
        if (c > c2) {
            return false;
        }
        boolean bl = false;
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            bl |= this.add(c3);
        }
        return false;
    }

    @Override
    public boolean removeFirst(char c) {
        this.checkRemoveModifiable();
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.nextChar() != c) continue;
            charIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(char c) {
        this.checkRemoveModifiable();
        boolean bl = false;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            if (charIterator.nextChar() != c) continue;
            charIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(char[] cArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (cArray != null) {
            CharIterator charIterator = this.iterator();
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != c) continue;
                    charIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(CharCollection charCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (charCollection != null) {
            CharIterator charIterator = this.iterator();
            while (charIterator.hasNext()) {
                if (!charCollection.contains(charIterator.nextChar())) continue;
                charIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(char c, char c2) {
        this.checkRemoveModifiable();
        if (c > c2) {
            return false;
        }
        boolean bl = false;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            char c3 = charIterator.nextChar();
            if (c3 < c || c3 > c2) continue;
            charIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(char[] cArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (cArray == null || cArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            CharIterator charIterator = this.iterator();
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                boolean bl2 = false;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != c) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                charIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(CharCollection charCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (charCollection == null || charCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            CharIterator charIterator = this.iterator();
            while (charIterator.hasNext()) {
                if (charCollection.contains(charIterator.nextChar())) continue;
                charIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(char c, char c2) {
        this.checkRemoveModifiable();
        boolean bl = false;
        CharIterator charIterator = this.iterator();
        while (charIterator.hasNext()) {
            char c3 = charIterator.nextChar();
            if (c3 >= c && c3 <= c2) continue;
            charIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Character[this.size()];
        CharIterator charIterator = this.iterator();
        int n = 0;
        while (charIterator.hasNext()) {
            objectArray[n] = charIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        CharIterator charIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = charIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Character c) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(c));
    }

    @Override
    public boolean addAll(Collection<? extends Character> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        CharIterator charIterator = this.iterator();
        boolean bl = charIterator.hasNext();
        while (bl) {
            stringBuffer.append(charIterator.nextChar());
            bl = charIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        CharIterator charIterator = this.iterator();
        for (int i = 0; charIterator.hasNext() && i < n3; ++i) {
            cArray[n2 + i] = charIterator.nextChar();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Character toObject(char c) {
        return CharUtils.toObject(c);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Character;
    }

    protected char toPrimitive(Object object) {
        return CharUtils.toPrimitive(object);
    }

    protected char[] toPrimitiveArray(Collection<?> collection) {
        return CharUtils.toPrimitiveArray(collection);
    }
}

