/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.collection.DoubleCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.DoubleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoubleCollection
extends AbstractPrimitiveCollectable<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public boolean contains(double d) {
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.nextDouble() != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (this.contains(dArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(DoubleCollection doubleCollection) {
        if (doubleCollection != null) {
            DoubleIterator doubleIterator = doubleCollection.iterator();
            while (doubleIterator.hasNext()) {
                if (this.contains(doubleIterator.nextDouble())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAny(double[] dArray) {
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!this.contains(dArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(DoubleCollection doubleCollection) {
        if (doubleCollection != null) {
            DoubleIterator doubleIterator = doubleCollection.iterator();
            while (doubleIterator.hasNext()) {
                if (!this.contains(doubleIterator.nextDouble())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double[] toDoubleArray() {
        if (this.size() == 0) {
            return DoubleUtils.EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[this.size()];
        this.arrayCopy(0, dArray, 0, this.size());
        return dArray;
    }

    @Override
    public double[] toDoubleArray(double[] dArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        double[] dArray2 = null;
        if (dArray == null) {
            dArray2 = new double[n + this.size()];
        } else if (dArray.length - n - this.size() >= 0) {
            dArray2 = dArray;
        } else {
            dArray2 = new double[n + this.size()];
            System.arraycopy(dArray, 0, dArray2, 0, n);
        }
        this.arrayCopy(0, dArray2, n, this.size());
        return dArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            doubleIterator.nextDouble();
            doubleIterator.remove();
        }
    }

    @Override
    public boolean add(double d) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(double[] dArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                bl |= this.add(dArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(DoubleCollection doubleCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (doubleCollection != null) {
            DoubleIterator doubleIterator = doubleCollection.iterator();
            while (doubleIterator.hasNext()) {
                bl |= this.add(doubleIterator.nextDouble());
            }
        }
        return bl;
    }

    @Override
    public boolean removeFirst(double d) {
        this.checkRemoveModifiable();
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.nextDouble() != d) continue;
            doubleIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(double d) {
        this.checkRemoveModifiable();
        boolean bl = false;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.nextDouble() != d) continue;
            doubleIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(double[] dArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (dArray != null) {
            DoubleIterator doubleIterator = this.iterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.nextDouble();
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] != d) continue;
                    doubleIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(DoubleCollection doubleCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (doubleCollection != null) {
            DoubleIterator doubleIterator = this.iterator();
            while (doubleIterator.hasNext()) {
                if (!doubleCollection.contains(doubleIterator.nextDouble())) continue;
                doubleIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(double[] dArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (dArray == null || dArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            DoubleIterator doubleIterator = this.iterator();
            while (doubleIterator.hasNext()) {
                double d = doubleIterator.nextDouble();
                boolean bl2 = false;
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] != d) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                doubleIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(DoubleCollection doubleCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (doubleCollection == null || doubleCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            DoubleIterator doubleIterator = this.iterator();
            while (doubleIterator.hasNext()) {
                if (doubleCollection.contains(doubleIterator.nextDouble())) continue;
                doubleIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Double[this.size()];
        DoubleIterator doubleIterator = this.iterator();
        int n = 0;
        while (doubleIterator.hasNext()) {
            objectArray[n] = doubleIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        DoubleIterator doubleIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = doubleIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Double d) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(d));
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        DoubleIterator doubleIterator = this.iterator();
        boolean bl = doubleIterator.hasNext();
        while (bl) {
            stringBuffer.append(doubleIterator.nextDouble());
            bl = doubleIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, double[] dArray, int n2, int n3) {
        DoubleIterator doubleIterator = this.iterator();
        for (int i = 0; doubleIterator.hasNext() && i < n3; ++i) {
            dArray[n2 + i] = doubleIterator.nextDouble();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Double toObject(double d) {
        return DoubleUtils.toObject(d);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Double;
    }

    protected double toPrimitive(Object object) {
        return DoubleUtils.toPrimitive(object);
    }

    protected double[] toPrimitiveArray(Collection<?> collection) {
        return DoubleUtils.toPrimitiveArray(collection);
    }
}

