/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.collection.FloatCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.FloatIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatCollection
extends AbstractPrimitiveCollectable<Float>
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    @Override
    public boolean contains(float f) {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.nextFloat() != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(float[] fArray) {
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.contains(fArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatCollection floatCollection) {
        if (floatCollection != null) {
            FloatIterator floatIterator = floatCollection.iterator();
            while (floatIterator.hasNext()) {
                if (this.contains(floatIterator.nextFloat())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAny(float[] fArray) {
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                if (!this.contains(fArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(FloatCollection floatCollection) {
        if (floatCollection != null) {
            FloatIterator floatIterator = floatCollection.iterator();
            while (floatIterator.hasNext()) {
                if (!this.contains(floatIterator.nextFloat())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public float[] toFloatArray() {
        if (this.size() == 0) {
            return FloatUtils.EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[this.size()];
        this.arrayCopy(0, fArray, 0, this.size());
        return fArray;
    }

    @Override
    public float[] toFloatArray(float[] fArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        float[] fArray2 = null;
        if (fArray == null) {
            fArray2 = new float[n + this.size()];
        } else if (fArray.length - n - this.size() >= 0) {
            fArray2 = fArray;
        } else {
            fArray2 = new float[n + this.size()];
            System.arraycopy(fArray, 0, fArray2, 0, n);
        }
        this.arrayCopy(0, fArray2, n, this.size());
        return fArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            floatIterator.nextFloat();
            floatIterator.remove();
        }
    }

    @Override
    public boolean add(float f) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(float[] fArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                bl |= this.add(fArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(FloatCollection floatCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (floatCollection != null) {
            FloatIterator floatIterator = floatCollection.iterator();
            while (floatIterator.hasNext()) {
                bl |= this.add(floatIterator.nextFloat());
            }
        }
        return bl;
    }

    @Override
    public boolean removeFirst(float f) {
        this.checkRemoveModifiable();
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.nextFloat() != f) continue;
            floatIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(float f) {
        this.checkRemoveModifiable();
        boolean bl = false;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatIterator.nextFloat() != f) continue;
            floatIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(float[] fArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (fArray != null) {
            FloatIterator floatIterator = this.iterator();
            while (floatIterator.hasNext()) {
                float f = floatIterator.nextFloat();
                for (int i = 0; i < fArray.length; ++i) {
                    if (fArray[i] != f) continue;
                    floatIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(FloatCollection floatCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (floatCollection != null) {
            FloatIterator floatIterator = this.iterator();
            while (floatIterator.hasNext()) {
                if (!floatCollection.contains(floatIterator.nextFloat())) continue;
                floatIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(float[] fArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (fArray == null || fArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            FloatIterator floatIterator = this.iterator();
            while (floatIterator.hasNext()) {
                float f = floatIterator.nextFloat();
                boolean bl2 = false;
                for (int i = 0; i < fArray.length; ++i) {
                    if (fArray[i] != f) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                floatIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(FloatCollection floatCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (floatCollection == null || floatCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            FloatIterator floatIterator = this.iterator();
            while (floatIterator.hasNext()) {
                if (floatCollection.contains(floatIterator.nextFloat())) continue;
                floatIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Float[this.size()];
        FloatIterator floatIterator = this.iterator();
        int n = 0;
        while (floatIterator.hasNext()) {
            objectArray[n] = floatIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        FloatIterator floatIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = floatIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Float f) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(f));
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        FloatIterator floatIterator = this.iterator();
        boolean bl = floatIterator.hasNext();
        while (bl) {
            stringBuffer.append(floatIterator.nextFloat());
            bl = floatIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, float[] fArray, int n2, int n3) {
        FloatIterator floatIterator = this.iterator();
        for (int i = 0; floatIterator.hasNext() && i < n3; ++i) {
            fArray[n2 + i] = floatIterator.nextFloat();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Float toObject(float f) {
        return FloatUtils.toObject(f);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Float;
    }

    protected float toPrimitive(Object object) {
        return FloatUtils.toPrimitive(object);
    }

    protected float[] toPrimitiveArray(Collection<?> collection) {
        return FloatUtils.toPrimitiveArray(collection);
    }
}

