/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.IntUtils;
import org.joda.primitives.collection.IntCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntCollection
extends AbstractPrimitiveCollectable<Integer>
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public boolean contains(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.nextInt() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (this.contains(nArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        if (intCollection != null) {
            IntIterator intIterator = intCollection.iterator();
            while (intIterator.hasNext()) {
                if (this.contains(intIterator.nextInt())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(int n, int n2) {
        if (n > n2) {
            return true;
        }
        for (int i = n; i <= n2; ++i) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (!this.contains(nArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(IntCollection intCollection) {
        if (intCollection != null) {
            IntIterator intIterator = intCollection.iterator();
            while (intIterator.hasNext()) {
                if (!this.contains(intIterator.nextInt())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(int n, int n2) {
        if (n > n2) {
            return false;
        }
        for (int i = n; i <= n2; ++i) {
            if (!this.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] toIntArray() {
        if (this.size() == 0) {
            return IntUtils.EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[this.size()];
        this.arrayCopy(0, nArray, 0, this.size());
        return nArray;
    }

    @Override
    public int[] toIntArray(int[] nArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        int[] nArray2 = null;
        if (nArray == null) {
            nArray2 = new int[n + this.size()];
        } else if (nArray.length - n - this.size() >= 0) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n + this.size()];
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        this.arrayCopy(0, nArray2, n, this.size());
        return nArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intIterator.nextInt();
            intIterator.remove();
        }
    }

    @Override
    public boolean add(int n) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(int[] nArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                bl |= this.add(nArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (intCollection != null) {
            IntIterator intIterator = intCollection.iterator();
            while (intIterator.hasNext()) {
                bl |= this.add(intIterator.nextInt());
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, int n2) {
        this.checkAddModifiable();
        if (n > n2) {
            return false;
        }
        boolean bl = false;
        for (int i = n; i <= n2; ++i) {
            bl |= this.add(i);
        }
        return false;
    }

    @Override
    public boolean removeFirst(int n) {
        this.checkRemoveModifiable();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.nextInt() != n) continue;
            intIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(int n) {
        this.checkRemoveModifiable();
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.nextInt() != n) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(int[] nArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (nArray != null) {
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    intIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (intCollection != null) {
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                if (!intCollection.contains(intIterator.nextInt())) continue;
                intIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(int n, int n2) {
        this.checkRemoveModifiable();
        if (n > n2) {
            return false;
        }
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            if (n3 < n || n3 > n2) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(int[] nArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (nArray == null || nArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                boolean bl2 = false;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                intIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(IntCollection intCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (intCollection == null || intCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                if (intCollection.contains(intIterator.nextInt())) continue;
                intIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(int n, int n2) {
        this.checkRemoveModifiable();
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            if (n3 >= n && n3 <= n2) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Integer[this.size()];
        IntIterator intIterator = this.iterator();
        int n = 0;
        while (intIterator.hasNext()) {
            objectArray[n] = intIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        IntIterator intIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = intIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Integer n) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(n));
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        IntIterator intIterator = this.iterator();
        boolean bl = intIterator.hasNext();
        while (bl) {
            stringBuffer.append(intIterator.nextInt());
            bl = intIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, int[] nArray, int n2, int n3) {
        IntIterator intIterator = this.iterator();
        for (int i = 0; intIterator.hasNext() && i < n3; ++i) {
            nArray[n2 + i] = intIterator.nextInt();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Integer toObject(int n) {
        return IntUtils.toObject(n);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Integer;
    }

    protected int toPrimitive(Object object) {
        return IntUtils.toPrimitive(object);
    }

    protected int[] toPrimitiveArray(Collection<?> collection) {
        return IntUtils.toPrimitiveArray(collection);
    }
}

