/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.LongUtils;
import org.joda.primitives.collection.LongCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.LongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongCollection
extends AbstractPrimitiveCollectable<Long>
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public boolean contains(long l) {
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.nextLong() != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(long[] lArray) {
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (this.contains(lArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(LongCollection longCollection) {
        if (longCollection != null) {
            LongIterator longIterator = longCollection.iterator();
            while (longIterator.hasNext()) {
                if (this.contains(longIterator.nextLong())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(long l, long l2) {
        if (l > l2) {
            return true;
        }
        for (long i = l; i <= l2; ++i) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(long[] lArray) {
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (!this.contains(lArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(LongCollection longCollection) {
        if (longCollection != null) {
            LongIterator longIterator = longCollection.iterator();
            while (longIterator.hasNext()) {
                if (!this.contains(longIterator.nextLong())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(long l, long l2) {
        if (l > l2) {
            return false;
        }
        for (long i = l; i <= l2; ++i) {
            if (!this.contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long[] toLongArray() {
        if (this.size() == 0) {
            return LongUtils.EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[this.size()];
        this.arrayCopy(0, lArray, 0, this.size());
        return lArray;
    }

    @Override
    public long[] toLongArray(long[] lArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        long[] lArray2 = null;
        if (lArray == null) {
            lArray2 = new long[n + this.size()];
        } else if (lArray.length - n - this.size() >= 0) {
            lArray2 = lArray;
        } else {
            lArray2 = new long[n + this.size()];
            System.arraycopy(lArray, 0, lArray2, 0, n);
        }
        this.arrayCopy(0, lArray2, n, this.size());
        return lArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            longIterator.nextLong();
            longIterator.remove();
        }
    }

    @Override
    public boolean add(long l) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(long[] lArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                bl |= this.add(lArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(LongCollection longCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (longCollection != null) {
            LongIterator longIterator = longCollection.iterator();
            while (longIterator.hasNext()) {
                bl |= this.add(longIterator.nextLong());
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(long l, long l2) {
        this.checkAddModifiable();
        if (l > l2) {
            return false;
        }
        boolean bl = false;
        for (long i = l; i <= l2; ++i) {
            bl |= this.add(i);
        }
        return false;
    }

    @Override
    public boolean removeFirst(long l) {
        this.checkRemoveModifiable();
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.nextLong() != l) continue;
            longIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(long l) {
        this.checkRemoveModifiable();
        boolean bl = false;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.nextLong() != l) continue;
            longIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(long[] lArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (lArray != null) {
            LongIterator longIterator = this.iterator();
            while (longIterator.hasNext()) {
                long l = longIterator.nextLong();
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray[i] != l) continue;
                    longIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(LongCollection longCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (longCollection != null) {
            LongIterator longIterator = this.iterator();
            while (longIterator.hasNext()) {
                if (!longCollection.contains(longIterator.nextLong())) continue;
                longIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(long l, long l2) {
        this.checkRemoveModifiable();
        if (l > l2) {
            return false;
        }
        boolean bl = false;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long l3 = longIterator.nextLong();
            if (l3 < l || l3 > l2) continue;
            longIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(long[] lArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (lArray == null || lArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            LongIterator longIterator = this.iterator();
            while (longIterator.hasNext()) {
                long l = longIterator.nextLong();
                boolean bl2 = false;
                for (int i = 0; i < lArray.length; ++i) {
                    if (lArray[i] != l) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                longIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(LongCollection longCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (longCollection == null || longCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            LongIterator longIterator = this.iterator();
            while (longIterator.hasNext()) {
                if (longCollection.contains(longIterator.nextLong())) continue;
                longIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(long l, long l2) {
        this.checkRemoveModifiable();
        boolean bl = false;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long l3 = longIterator.nextLong();
            if (l3 >= l && l3 <= l2) continue;
            longIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Long[this.size()];
        LongIterator longIterator = this.iterator();
        int n = 0;
        while (longIterator.hasNext()) {
            objectArray[n] = longIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        LongIterator longIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = longIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Long l) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(l));
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        LongIterator longIterator = this.iterator();
        boolean bl = longIterator.hasNext();
        while (bl) {
            stringBuffer.append(longIterator.nextLong());
            bl = longIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, long[] lArray, int n2, int n3) {
        LongIterator longIterator = this.iterator();
        for (int i = 0; longIterator.hasNext() && i < n3; ++i) {
            lArray[n2 + i] = longIterator.nextLong();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Long toObject(long l) {
        return LongUtils.toObject(l);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Long;
    }

    protected long toPrimitive(Object object) {
        return LongUtils.toPrimitive(object);
    }

    protected long[] toPrimitiveArray(Collection<?> collection) {
        return LongUtils.toPrimitiveArray(collection);
    }
}

