/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.collection.ShortCollection;
import org.joda.primitives.collection.impl.AbstractPrimitiveCollectable;
import org.joda.primitives.iterator.ShortIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShortCollection
extends AbstractPrimitiveCollectable<Short>
implements ShortCollection {
    protected AbstractShortCollection() {
    }

    @Override
    public boolean contains(short s) {
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.nextShort() != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(short[] sArray) {
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                if (this.contains(sArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortCollection shortCollection) {
        if (shortCollection != null) {
            ShortIterator shortIterator = shortCollection.iterator();
            while (shortIterator.hasNext()) {
                if (this.contains(shortIterator.nextShort())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(short s, short s2) {
        if (s > s2) {
            return true;
        }
        for (short s3 = s; s3 <= s2; s3 = (short)(s3 + 1)) {
            if (this.contains(s3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(short[] sArray) {
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                if (!this.contains(sArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(ShortCollection shortCollection) {
        if (shortCollection != null) {
            ShortIterator shortIterator = shortCollection.iterator();
            while (shortIterator.hasNext()) {
                if (!this.contains(shortIterator.nextShort())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAny(short s, short s2) {
        if (s > s2) {
            return false;
        }
        for (short s3 = s; s3 <= s2; s3 = (short)(s3 + 1)) {
            if (!this.contains(s3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public short[] toShortArray() {
        if (this.size() == 0) {
            return ShortUtils.EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[this.size()];
        this.arrayCopy(0, sArray, 0, this.size());
        return sArray;
    }

    @Override
    public short[] toShortArray(short[] sArray, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Start index must not be negative: " + n);
        }
        short[] sArray2 = null;
        if (sArray == null) {
            sArray2 = new short[n + this.size()];
        } else if (sArray.length - n - this.size() >= 0) {
            sArray2 = sArray;
        } else {
            sArray2 = new short[n + this.size()];
            System.arraycopy(sArray, 0, sArray2, 0, n);
        }
        this.arrayCopy(0, sArray2, n, this.size());
        return sArray2;
    }

    @Override
    public void clear() {
        this.checkRemoveModifiable();
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            shortIterator.nextShort();
            shortIterator.remove();
        }
    }

    @Override
    public boolean add(short s) {
        throw new UnsupportedOperationException("Collection does not support add");
    }

    @Override
    public boolean addAll(short[] sArray) {
        this.checkAddModifiable();
        boolean bl = false;
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                bl |= this.add(sArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(ShortCollection shortCollection) {
        this.checkAddModifiable();
        boolean bl = false;
        if (shortCollection != null) {
            ShortIterator shortIterator = shortCollection.iterator();
            while (shortIterator.hasNext()) {
                bl |= this.add(shortIterator.nextShort());
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(short s, short s2) {
        this.checkAddModifiable();
        if (s > s2) {
            return false;
        }
        boolean bl = false;
        for (short s3 = s; s3 <= s2; s3 = (short)(s3 + 1)) {
            bl |= this.add(s3);
        }
        return false;
    }

    @Override
    public boolean removeFirst(short s) {
        this.checkRemoveModifiable();
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.nextShort() != s) continue;
            shortIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(short s) {
        this.checkRemoveModifiable();
        boolean bl = false;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.nextShort() != s) continue;
            shortIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(short[] sArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (sArray != null) {
            ShortIterator shortIterator = this.iterator();
            while (shortIterator.hasNext()) {
                short s = shortIterator.nextShort();
                for (int i = 0; i < sArray.length; ++i) {
                    if (sArray[i] != s) continue;
                    shortIterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(ShortCollection shortCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (shortCollection != null) {
            ShortIterator shortIterator = this.iterator();
            while (shortIterator.hasNext()) {
                if (!shortCollection.contains(shortIterator.nextShort())) continue;
                shortIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(short s, short s2) {
        this.checkRemoveModifiable();
        if (s > s2) {
            return false;
        }
        boolean bl = false;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            short s3 = shortIterator.nextShort();
            if (s3 < s || s3 > s2) continue;
            shortIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(short[] sArray) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (sArray == null || sArray.length == 0) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            ShortIterator shortIterator = this.iterator();
            while (shortIterator.hasNext()) {
                short s = shortIterator.nextShort();
                boolean bl2 = false;
                for (int i = 0; i < sArray.length; ++i) {
                    if (sArray[i] != s) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                shortIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(ShortCollection shortCollection) {
        this.checkRemoveModifiable();
        boolean bl = false;
        if (shortCollection == null || shortCollection.isEmpty()) {
            bl = !this.isEmpty();
            this.clear();
        } else {
            ShortIterator shortIterator = this.iterator();
            while (shortIterator.hasNext()) {
                if (shortCollection.contains(shortIterator.nextShort())) continue;
                shortIterator.remove();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean retainAll(short s, short s2) {
        this.checkRemoveModifiable();
        boolean bl = false;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            short s3 = shortIterator.nextShort();
            if (s3 >= s && s3 <= s2) continue;
            shortIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.toPrimitive(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection == this || collection.size() == 0) {
            return true;
        }
        if (this.size() == 0) {
            return false;
        }
        return this.containsAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean containsAny(Collection<?> collection) {
        if (this.size() == 0 || collection.size() == 0) {
            return false;
        }
        if (collection == this) {
            return true;
        }
        return this.containsAny(this.toPrimitiveArray(collection));
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Short[this.size()];
        ShortIterator shortIterator = this.iterator();
        int n = 0;
        while (shortIterator.hasNext()) {
            objectArray[n] = shortIterator.next();
            ++n;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        ShortIterator shortIterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = shortIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public boolean add(Short s) {
        this.checkAddModifiable();
        return this.add(this.toPrimitive(s));
    }

    @Override
    public boolean addAll(Collection<? extends Short> collection) {
        this.checkAddModifiable();
        return this.addAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean remove(Object object) {
        this.checkRemoveModifiable();
        return this.removeFirst(this.toPrimitive(object));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            int n = this.size();
            this.clear();
            return this.size() != n;
        }
        return this.removeAll(this.toPrimitiveArray(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkRemoveModifiable();
        if (collection == this) {
            return false;
        }
        return this.retainAll(this.toPrimitiveArray(collection));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        ShortIterator shortIterator = this.iterator();
        boolean bl = shortIterator.hasNext();
        while (bl) {
            stringBuffer.append(shortIterator.nextShort());
            bl = shortIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void arrayCopy(int n, short[] sArray, int n2, int n3) {
        ShortIterator shortIterator = this.iterator();
        for (int i = 0; shortIterator.hasNext() && i < n3; ++i) {
            sArray[n2 + i] = shortIterator.nextShort();
        }
    }

    protected boolean isAddModifiable() {
        return false;
    }

    protected boolean isRemoveModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable();
    }

    protected void checkAddModifiable() {
        if (!this.isAddModifiable()) {
            throw new UnsupportedOperationException("Collection does not support add");
        }
    }

    protected void checkRemoveModifiable() {
        if (!this.isRemoveModifiable()) {
            throw new UnsupportedOperationException("Collection does not support remove");
        }
    }

    protected Short toObject(short s) {
        return ShortUtils.toObject(s);
    }

    protected boolean isToPrimitivePossible(Object object) {
        return object instanceof Short;
    }

    protected short toPrimitive(Object object) {
        return ShortUtils.toPrimitive(object);
    }

    protected short[] toPrimitiveArray(Collection<?> collection) {
        return ShortUtils.toPrimitiveArray(collection);
    }
}

