/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.collection.BooleanCollection;
import org.joda.primitives.collection.impl.AbstractBooleanCollection;
import org.joda.primitives.iterator.BooleanIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBooleanCollection
extends AbstractBooleanCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private boolean[] data;
    private int size;

    public ArrayBooleanCollection() {
        this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
    }

    public ArrayBooleanCollection(int n) {
        this.data = n <= 0 ? BooleanUtils.EMPTY_BOOLEAN_ARRAY : new boolean[n];
    }

    public ArrayBooleanCollection(boolean[] blArray) {
        if (blArray == null) {
            this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        } else {
            this.data = (boolean[])blArray.clone();
            this.size = blArray.length;
        }
    }

    public ArrayBooleanCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        } else if (collection instanceof BooleanCollection) {
            BooleanCollection booleanCollection = (BooleanCollection)collection;
            this.size = booleanCollection.size();
            this.data = new boolean[this.size];
            booleanCollection.toBooleanArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayBooleanCollection(Iterator<Boolean> iterator) {
        if (iterator == null) {
            this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        } else if (iterator instanceof BooleanIterator) {
            BooleanIterator booleanIterator = (BooleanIterator)iterator;
            this.data = new boolean[4];
            while (booleanIterator.hasNext()) {
                this.add(booleanIterator.nextBoolean());
            }
        } else {
            this.data = new boolean[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BooleanIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(boolean bl) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = bl;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            boolean[] blArray = new boolean[this.size];
            System.arraycopy(this.data, 0, blArray, 0, this.size);
            this.data = blArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(boolean bl) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(boolean[] blArray) {
        this.checkAddModifiable();
        if (blArray == null || blArray.length == 0) {
            return false;
        }
        return this.doAdd(0, blArray);
    }

    @Override
    public boolean addAll(BooleanCollection booleanCollection) {
        this.checkAddModifiable();
        if (booleanCollection == null || booleanCollection.size() == 0) {
            return false;
        }
        int n = booleanCollection.size();
        this.ensureCapacity(this.size + n);
        booleanCollection.toBooleanArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public Object clone() {
        ArrayBooleanCollection arrayBooleanCollection = (ArrayBooleanCollection)super.clone();
        arrayBooleanCollection.data = (boolean[])this.data.clone();
        return arrayBooleanCollection;
    }

    @Override
    protected void arrayCopy(int n, boolean[] blArray, int n2, int n3) {
        System.arraycopy(this.data, n, blArray, n2, n3);
    }

    protected boolean doAdd(int n, boolean[] blArray) {
        int n2 = blArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(blArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        boolean[] blArray = new boolean[n3];
        System.arraycopy(this.data, 0, blArray, 0, n2);
        this.data = blArray;
    }

    protected static class PIterator
    implements BooleanIterator {
        private final ArrayBooleanCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayBooleanCollection arrayBooleanCollection) {
            this.collection = arrayBooleanCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Boolean next() {
            return this.collection.toObject(this.nextBoolean());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

