/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.collection.ByteCollection;
import org.joda.primitives.collection.impl.AbstractByteCollection;
import org.joda.primitives.iterator.ByteIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayByteCollection
extends AbstractByteCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private byte[] data;
    private int size;

    public ArrayByteCollection() {
        this.data = ByteUtils.EMPTY_BYTE_ARRAY;
    }

    public ArrayByteCollection(int n) {
        this.data = n <= 0 ? ByteUtils.EMPTY_BYTE_ARRAY : new byte[n];
    }

    public ArrayByteCollection(byte[] byArray) {
        if (byArray == null) {
            this.data = ByteUtils.EMPTY_BYTE_ARRAY;
        } else {
            this.data = (byte[])byArray.clone();
            this.size = byArray.length;
        }
    }

    public ArrayByteCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = ByteUtils.EMPTY_BYTE_ARRAY;
        } else if (collection instanceof ByteCollection) {
            ByteCollection byteCollection = (ByteCollection)collection;
            this.size = byteCollection.size();
            this.data = new byte[this.size];
            byteCollection.toByteArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayByteCollection(Iterator<Byte> iterator) {
        if (iterator == null) {
            this.data = ByteUtils.EMPTY_BYTE_ARRAY;
        } else if (iterator instanceof ByteIterator) {
            ByteIterator byteIterator = (ByteIterator)iterator;
            this.data = new byte[4];
            while (byteIterator.hasNext()) {
                this.add(byteIterator.nextByte());
            }
        } else {
            this.data = new byte[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ByteIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(byte by) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = by;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.data, 0, byArray, 0, this.size);
            this.data = byArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(byte by) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(byte[] byArray) {
        this.checkAddModifiable();
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        return this.doAdd(0, byArray);
    }

    @Override
    public boolean addAll(ByteCollection byteCollection) {
        this.checkAddModifiable();
        if (byteCollection == null || byteCollection.size() == 0) {
            return false;
        }
        int n = byteCollection.size();
        this.ensureCapacity(this.size + n);
        byteCollection.toByteArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public boolean addAll(byte by, byte by2) {
        byte by3;
        int n = by2 - by + 1;
        if (n < 0) {
            return false;
        }
        this.ensureCapacity(this.size + n);
        for (by3 = by; by3 < by2; by3 = (byte)(by3 + 1)) {
            byte by4 = by3;
            this.data[this.size++] = by4;
        }
        this.data[this.size++] = by3;
        return true;
    }

    @Override
    public Object clone() {
        ArrayByteCollection arrayByteCollection = (ArrayByteCollection)super.clone();
        arrayByteCollection.data = (byte[])this.data.clone();
        return arrayByteCollection;
    }

    @Override
    protected void arrayCopy(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, n, byArray, n2, n3);
    }

    protected boolean doAdd(int n, byte[] byArray) {
        int n2 = byArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(byArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.data, 0, byArray, 0, n2);
        this.data = byArray;
    }

    protected static class PIterator
    implements ByteIterator {
        private final ArrayByteCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayByteCollection arrayByteCollection) {
            this.collection = arrayByteCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Byte next() {
            return this.collection.toObject(this.nextByte());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

