/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.CharUtils;
import org.joda.primitives.collection.CharCollection;
import org.joda.primitives.collection.impl.AbstractCharCollection;
import org.joda.primitives.iterator.CharIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCharCollection
extends AbstractCharCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private char[] data;
    private int size;

    public ArrayCharCollection() {
        this.data = CharUtils.EMPTY_CHAR_ARRAY;
    }

    public ArrayCharCollection(int n) {
        this.data = n <= 0 ? CharUtils.EMPTY_CHAR_ARRAY : new char[n];
    }

    public ArrayCharCollection(char[] cArray) {
        if (cArray == null) {
            this.data = CharUtils.EMPTY_CHAR_ARRAY;
        } else {
            this.data = (char[])cArray.clone();
            this.size = cArray.length;
        }
    }

    public ArrayCharCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = CharUtils.EMPTY_CHAR_ARRAY;
        } else if (collection instanceof CharCollection) {
            CharCollection charCollection = (CharCollection)collection;
            this.size = charCollection.size();
            this.data = new char[this.size];
            charCollection.toCharArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayCharCollection(Iterator<Character> iterator) {
        if (iterator == null) {
            this.data = CharUtils.EMPTY_CHAR_ARRAY;
        } else if (iterator instanceof CharIterator) {
            CharIterator charIterator = (CharIterator)iterator;
            this.data = new char[4];
            while (charIterator.hasNext()) {
                this.add(charIterator.nextChar());
            }
        } else {
            this.data = new char[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public CharIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(char c) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = c;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            char[] cArray = new char[this.size];
            System.arraycopy(this.data, 0, cArray, 0, this.size);
            this.data = cArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(char[] cArray) {
        this.checkAddModifiable();
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        return this.doAdd(0, cArray);
    }

    @Override
    public boolean addAll(CharCollection charCollection) {
        this.checkAddModifiable();
        if (charCollection == null || charCollection.size() == 0) {
            return false;
        }
        int n = charCollection.size();
        this.ensureCapacity(this.size + n);
        charCollection.toCharArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public boolean addAll(char c, char c2) {
        char c3;
        int n = c2 - c + 1;
        if (n < 0) {
            return false;
        }
        this.ensureCapacity(this.size + n);
        for (c3 = c; c3 < c2; c3 = (char)(c3 + '\u0001')) {
            char c4 = c3;
            this.data[this.size++] = c4;
        }
        this.data[this.size++] = c3;
        return true;
    }

    @Override
    public Object clone() {
        ArrayCharCollection arrayCharCollection = (ArrayCharCollection)super.clone();
        arrayCharCollection.data = (char[])this.data.clone();
        return arrayCharCollection;
    }

    @Override
    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(this.data, n, cArray, n2, n3);
    }

    protected boolean doAdd(int n, char[] cArray) {
        int n2 = cArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(cArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.data, 0, cArray, 0, n2);
        this.data = cArray;
    }

    protected static class PIterator
    implements CharIterator {
        private final ArrayCharCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayCharCollection arrayCharCollection) {
            this.collection = arrayCharCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Character next() {
            return this.collection.toObject(this.nextChar());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

