/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.collection.DoubleCollection;
import org.joda.primitives.collection.impl.AbstractDoubleCollection;
import org.joda.primitives.iterator.DoubleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDoubleCollection
extends AbstractDoubleCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private double[] data;
    private int size;

    public ArrayDoubleCollection() {
        this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
    }

    public ArrayDoubleCollection(int n) {
        this.data = n <= 0 ? DoubleUtils.EMPTY_DOUBLE_ARRAY : new double[n];
    }

    public ArrayDoubleCollection(double[] dArray) {
        if (dArray == null) {
            this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
        } else {
            this.data = (double[])dArray.clone();
            this.size = dArray.length;
        }
    }

    public ArrayDoubleCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
        } else if (collection instanceof DoubleCollection) {
            DoubleCollection doubleCollection = (DoubleCollection)collection;
            this.size = doubleCollection.size();
            this.data = new double[this.size];
            doubleCollection.toDoubleArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayDoubleCollection(Iterator<Double> iterator) {
        if (iterator == null) {
            this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
        } else if (iterator instanceof DoubleIterator) {
            DoubleIterator doubleIterator = (DoubleIterator)iterator;
            this.data = new double[4];
            while (doubleIterator.hasNext()) {
                this.add(doubleIterator.nextDouble());
            }
        } else {
            this.data = new double[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DoubleIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(double d) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = d;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            double[] dArray = new double[this.size];
            System.arraycopy(this.data, 0, dArray, 0, this.size);
            this.data = dArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(double[] dArray) {
        this.checkAddModifiable();
        if (dArray == null || dArray.length == 0) {
            return false;
        }
        return this.doAdd(0, dArray);
    }

    @Override
    public boolean addAll(DoubleCollection doubleCollection) {
        this.checkAddModifiable();
        if (doubleCollection == null || doubleCollection.size() == 0) {
            return false;
        }
        int n = doubleCollection.size();
        this.ensureCapacity(this.size + n);
        doubleCollection.toDoubleArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public Object clone() {
        ArrayDoubleCollection arrayDoubleCollection = (ArrayDoubleCollection)super.clone();
        arrayDoubleCollection.data = (double[])this.data.clone();
        return arrayDoubleCollection;
    }

    @Override
    protected void arrayCopy(int n, double[] dArray, int n2, int n3) {
        System.arraycopy(this.data, n, dArray, n2, n3);
    }

    protected boolean doAdd(int n, double[] dArray) {
        int n2 = dArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(dArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        double[] dArray = new double[n3];
        System.arraycopy(this.data, 0, dArray, 0, n2);
        this.data = dArray;
    }

    protected static class PIterator
    implements DoubleIterator {
        private final ArrayDoubleCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayDoubleCollection arrayDoubleCollection) {
            this.collection = arrayDoubleCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Double next() {
            return this.collection.toObject(this.nextDouble());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

