/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.collection.FloatCollection;
import org.joda.primitives.collection.impl.AbstractFloatCollection;
import org.joda.primitives.iterator.FloatIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFloatCollection
extends AbstractFloatCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private float[] data;
    private int size;

    public ArrayFloatCollection() {
        this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
    }

    public ArrayFloatCollection(int n) {
        this.data = n <= 0 ? FloatUtils.EMPTY_FLOAT_ARRAY : new float[n];
    }

    public ArrayFloatCollection(float[] fArray) {
        if (fArray == null) {
            this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
        } else {
            this.data = (float[])fArray.clone();
            this.size = fArray.length;
        }
    }

    public ArrayFloatCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
        } else if (collection instanceof FloatCollection) {
            FloatCollection floatCollection = (FloatCollection)collection;
            this.size = floatCollection.size();
            this.data = new float[this.size];
            floatCollection.toFloatArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayFloatCollection(Iterator<Float> iterator) {
        if (iterator == null) {
            this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
        } else if (iterator instanceof FloatIterator) {
            FloatIterator floatIterator = (FloatIterator)iterator;
            this.data = new float[4];
            while (floatIterator.hasNext()) {
                this.add(floatIterator.nextFloat());
            }
        } else {
            this.data = new float[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public FloatIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(float f) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = f;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            float[] fArray = new float[this.size];
            System.arraycopy(this.data, 0, fArray, 0, this.size);
            this.data = fArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(float f) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(float[] fArray) {
        this.checkAddModifiable();
        if (fArray == null || fArray.length == 0) {
            return false;
        }
        return this.doAdd(0, fArray);
    }

    @Override
    public boolean addAll(FloatCollection floatCollection) {
        this.checkAddModifiable();
        if (floatCollection == null || floatCollection.size() == 0) {
            return false;
        }
        int n = floatCollection.size();
        this.ensureCapacity(this.size + n);
        floatCollection.toFloatArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public Object clone() {
        ArrayFloatCollection arrayFloatCollection = (ArrayFloatCollection)super.clone();
        arrayFloatCollection.data = (float[])this.data.clone();
        return arrayFloatCollection;
    }

    @Override
    protected void arrayCopy(int n, float[] fArray, int n2, int n3) {
        System.arraycopy(this.data, n, fArray, n2, n3);
    }

    protected boolean doAdd(int n, float[] fArray) {
        int n2 = fArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(fArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        float[] fArray = new float[n3];
        System.arraycopy(this.data, 0, fArray, 0, n2);
        this.data = fArray;
    }

    protected static class PIterator
    implements FloatIterator {
        private final ArrayFloatCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayFloatCollection arrayFloatCollection) {
            this.collection = arrayFloatCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Float next() {
            return this.collection.toObject(this.nextFloat());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

