/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.IntUtils;
import org.joda.primitives.collection.IntCollection;
import org.joda.primitives.collection.impl.AbstractIntCollection;
import org.joda.primitives.iterator.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIntCollection
extends AbstractIntCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private int[] data;
    private int size;

    public ArrayIntCollection() {
        this.data = IntUtils.EMPTY_INT_ARRAY;
    }

    public ArrayIntCollection(int n) {
        this.data = n <= 0 ? IntUtils.EMPTY_INT_ARRAY : new int[n];
    }

    public ArrayIntCollection(int[] nArray) {
        if (nArray == null) {
            this.data = IntUtils.EMPTY_INT_ARRAY;
        } else {
            this.data = (int[])nArray.clone();
            this.size = nArray.length;
        }
    }

    public ArrayIntCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = IntUtils.EMPTY_INT_ARRAY;
        } else if (collection instanceof IntCollection) {
            IntCollection intCollection = (IntCollection)collection;
            this.size = intCollection.size();
            this.data = new int[this.size];
            intCollection.toIntArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayIntCollection(Iterator<Integer> iterator) {
        if (iterator == null) {
            this.data = IntUtils.EMPTY_INT_ARRAY;
        } else if (iterator instanceof IntIterator) {
            IntIterator intIterator = (IntIterator)iterator;
            this.data = new int[4];
            while (intIterator.hasNext()) {
                this.add(intIterator.nextInt());
            }
        } else {
            this.data = new int[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IntIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = n;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            int[] nArray = new int[this.size];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(int[] nArray) {
        this.checkAddModifiable();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        return this.doAdd(0, nArray);
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        this.checkAddModifiable();
        if (intCollection == null || intCollection.size() == 0) {
            return false;
        }
        int n = intCollection.size();
        this.ensureCapacity(this.size + n);
        intCollection.toIntArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public boolean addAll(int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 < 0) {
            return false;
        }
        this.ensureCapacity(this.size + n3);
        int n4 = n;
        while (n4 < n2) {
            this.data[this.size++] = n4++;
        }
        this.data[this.size++] = n4;
        return true;
    }

    @Override
    public Object clone() {
        ArrayIntCollection arrayIntCollection = (ArrayIntCollection)super.clone();
        arrayIntCollection.data = (int[])this.data.clone();
        return arrayIntCollection;
    }

    @Override
    protected void arrayCopy(int n, int[] nArray, int n2, int n3) {
        System.arraycopy(this.data, n, nArray, n2, n3);
    }

    protected boolean doAdd(int n, int[] nArray) {
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(nArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.data, 0, nArray, 0, n2);
        this.data = nArray;
    }

    protected static class PIterator
    implements IntIterator {
        private final ArrayIntCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayIntCollection arrayIntCollection) {
            this.collection = arrayIntCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Integer next() {
            return this.collection.toObject(this.nextInt());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

