/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.LongUtils;
import org.joda.primitives.collection.LongCollection;
import org.joda.primitives.collection.impl.AbstractLongCollection;
import org.joda.primitives.iterator.LongIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLongCollection
extends AbstractLongCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private long[] data;
    private int size;

    public ArrayLongCollection() {
        this.data = LongUtils.EMPTY_LONG_ARRAY;
    }

    public ArrayLongCollection(int n) {
        this.data = n <= 0 ? LongUtils.EMPTY_LONG_ARRAY : new long[n];
    }

    public ArrayLongCollection(long[] lArray) {
        if (lArray == null) {
            this.data = LongUtils.EMPTY_LONG_ARRAY;
        } else {
            this.data = (long[])lArray.clone();
            this.size = lArray.length;
        }
    }

    public ArrayLongCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = LongUtils.EMPTY_LONG_ARRAY;
        } else if (collection instanceof LongCollection) {
            LongCollection longCollection = (LongCollection)collection;
            this.size = longCollection.size();
            this.data = new long[this.size];
            longCollection.toLongArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayLongCollection(Iterator<Long> iterator) {
        if (iterator == null) {
            this.data = LongUtils.EMPTY_LONG_ARRAY;
        } else if (iterator instanceof LongIterator) {
            LongIterator longIterator = (LongIterator)iterator;
            this.data = new long[4];
            while (longIterator.hasNext()) {
                this.add(longIterator.nextLong());
            }
        } else {
            this.data = new long[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public LongIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(long l) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = l;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            long[] lArray = new long[this.size];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            this.data = lArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(long l) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(long[] lArray) {
        this.checkAddModifiable();
        if (lArray == null || lArray.length == 0) {
            return false;
        }
        return this.doAdd(0, lArray);
    }

    @Override
    public boolean addAll(LongCollection longCollection) {
        this.checkAddModifiable();
        if (longCollection == null || longCollection.size() == 0) {
            return false;
        }
        int n = longCollection.size();
        this.ensureCapacity(this.size + n);
        longCollection.toLongArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public boolean addAll(long l, long l2) {
        long l3 = l2 - l + 1L;
        if (l3 < 0L) {
            return false;
        }
        long l4 = (long)this.size + l3;
        if (l4 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range too large");
        }
        this.ensureCapacity((int)l4);
        long l5 = l;
        while (l5 < l2) {
            this.data[this.size++] = l5++;
        }
        this.data[this.size++] = l5;
        return true;
    }

    @Override
    public Object clone() {
        ArrayLongCollection arrayLongCollection = (ArrayLongCollection)super.clone();
        arrayLongCollection.data = (long[])this.data.clone();
        return arrayLongCollection;
    }

    @Override
    protected void arrayCopy(int n, long[] lArray, int n2, int n3) {
        System.arraycopy(this.data, n, lArray, n2, n3);
    }

    protected boolean doAdd(int n, long[] lArray) {
        int n2 = lArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(lArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        long[] lArray = new long[n3];
        System.arraycopy(this.data, 0, lArray, 0, n2);
        this.data = lArray;
    }

    protected static class PIterator
    implements LongIterator {
        private final ArrayLongCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayLongCollection arrayLongCollection) {
            this.collection = arrayLongCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Long next() {
            return this.collection.toObject(this.nextLong());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

