/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.collection.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.collection.ShortCollection;
import org.joda.primitives.collection.impl.AbstractShortCollection;
import org.joda.primitives.iterator.ShortIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayShortCollection
extends AbstractShortCollection
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private short[] data;
    private int size;

    public ArrayShortCollection() {
        this.data = ShortUtils.EMPTY_SHORT_ARRAY;
    }

    public ArrayShortCollection(int n) {
        this.data = n <= 0 ? ShortUtils.EMPTY_SHORT_ARRAY : new short[n];
    }

    public ArrayShortCollection(short[] sArray) {
        if (sArray == null) {
            this.data = ShortUtils.EMPTY_SHORT_ARRAY;
        } else {
            this.data = (short[])sArray.clone();
            this.size = sArray.length;
        }
    }

    public ArrayShortCollection(Collection<?> collection) {
        if (collection == null) {
            this.data = ShortUtils.EMPTY_SHORT_ARRAY;
        } else if (collection instanceof ShortCollection) {
            ShortCollection shortCollection = (ShortCollection)collection;
            this.size = shortCollection.size();
            this.data = new short[this.size];
            shortCollection.toShortArray(this.data, 0);
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    public ArrayShortCollection(Iterator<Short> iterator) {
        if (iterator == null) {
            this.data = ShortUtils.EMPTY_SHORT_ARRAY;
        } else if (iterator instanceof ShortIterator) {
            ShortIterator shortIterator = (ShortIterator)iterator;
            this.data = new short[4];
            while (shortIterator.hasNext()) {
                this.add(shortIterator.nextShort());
            }
        } else {
            this.data = new short[4];
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ShortIterator iterator() {
        return new PIterator(this);
    }

    @Override
    public boolean add(short s) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = s;
        return true;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            short[] sArray = new short[this.size];
            System.arraycopy(this.data, 0, sArray, 0, this.size);
            this.data = sArray;
        }
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean contains(short s) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(short[] sArray) {
        this.checkAddModifiable();
        if (sArray == null || sArray.length == 0) {
            return false;
        }
        return this.doAdd(0, sArray);
    }

    @Override
    public boolean addAll(ShortCollection shortCollection) {
        this.checkAddModifiable();
        if (shortCollection == null || shortCollection.size() == 0) {
            return false;
        }
        int n = shortCollection.size();
        this.ensureCapacity(this.size + n);
        shortCollection.toShortArray(this.data, this.size);
        this.size += n;
        return true;
    }

    @Override
    public boolean addAll(short s, short s2) {
        short s3;
        int n = s2 - s + 1;
        if (n < 0) {
            return false;
        }
        this.ensureCapacity(this.size + n);
        for (s3 = s; s3 < s2; s3 = (short)(s3 + 1)) {
            short s4 = s3;
            this.data[this.size++] = s4;
        }
        this.data[this.size++] = s3;
        return true;
    }

    @Override
    public Object clone() {
        ArrayShortCollection arrayShortCollection = (ArrayShortCollection)super.clone();
        arrayShortCollection.data = (short[])this.data.clone();
        return arrayShortCollection;
    }

    @Override
    protected void arrayCopy(int n, short[] sArray, int n2, int n3) {
        System.arraycopy(this.data, n, sArray, n2, n3);
    }

    protected boolean doAdd(int n, short[] sArray) {
        int n2 = sArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(sArray, 0, this.data, this.size, n2);
        this.size += n2;
        return n2 > 0;
    }

    protected void doRemoveIndex(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 - n2 < 4) {
            n3 = n2 + 4;
        }
        if (n3 < n) {
            n3 = n;
        }
        short[] sArray = new short[n3];
        System.arraycopy(this.data, 0, sArray, 0, n2);
        this.data = sArray;
    }

    protected static class PIterator
    implements ShortIterator {
        private final ArrayShortCollection collection;
        private int cursor = 0;
        private boolean canRemove = false;

        protected PIterator(ArrayShortCollection arrayShortCollection) {
            this.collection = arrayShortCollection;
        }

        public boolean hasNext() {
            return this.cursor < this.collection.size;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.canRemove = true;
            return this.collection.data[this.cursor++];
        }

        public Short next() {
            return this.collection.toObject(this.nextShort());
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.collection.doRemoveIndex(--this.cursor);
            this.canRemove = false;
        }

        public boolean isModifiable() {
            return this.collection.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.cursor = 0;
        }
    }
}

