/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.iterator.BooleanIterator;

public class ArrayBooleanIterator
implements BooleanIterator {
    protected final boolean[] array;
    protected int cursor = 0;

    public static ArrayBooleanIterator copyOf(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayBooleanIterator((boolean[])blArray.clone());
    }

    public ArrayBooleanIterator(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = blArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public boolean nextBoolean() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Boolean next() {
        return BooleanUtils.toObject(this.nextBoolean());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayBooleanIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

