/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.iterator.ByteIterator;

public class ArrayByteIterator
implements ByteIterator {
    protected final byte[] array;
    protected int cursor = 0;

    public static ArrayByteIterator copyOf(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayByteIterator((byte[])byArray.clone());
    }

    public ArrayByteIterator(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = byArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public byte nextByte() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Byte next() {
        return ByteUtils.toObject(this.nextByte());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayByteIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

