/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.CharUtils;
import org.joda.primitives.iterator.CharIterator;

public class ArrayCharIterator
implements CharIterator {
    protected final char[] array;
    protected int cursor = 0;

    public static ArrayCharIterator copyOf(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayCharIterator((char[])cArray.clone());
    }

    public ArrayCharIterator(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = cArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public char nextChar() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Character next() {
        return CharUtils.toObject(this.nextChar());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayCharIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

