/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.iterator.DoubleIterator;

public class ArrayDoubleIterator
implements DoubleIterator {
    protected final double[] array;
    protected int cursor = 0;

    public static ArrayDoubleIterator copyOf(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayDoubleIterator((double[])dArray.clone());
    }

    public ArrayDoubleIterator(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = dArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public double nextDouble() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Double next() {
        return DoubleUtils.toObject(this.nextDouble());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayDoubleIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

