/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.iterator.FloatIterator;

public class ArrayFloatIterator
implements FloatIterator {
    protected final float[] array;
    protected int cursor = 0;

    public static ArrayFloatIterator copyOf(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayFloatIterator((float[])fArray.clone());
    }

    public ArrayFloatIterator(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = fArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public float nextFloat() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Float next() {
        return FloatUtils.toObject(this.nextFloat());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayFloatIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

