/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.IntUtils;
import org.joda.primitives.iterator.IntIterator;

public class ArrayIntIterator
implements IntIterator {
    protected final int[] array;
    protected int cursor = 0;

    public static ArrayIntIterator copyOf(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayIntIterator((int[])nArray.clone());
    }

    public ArrayIntIterator(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = nArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Integer next() {
        return IntUtils.toObject(this.nextInt());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayIntIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

