/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.LongUtils;
import org.joda.primitives.iterator.LongIterator;

public class ArrayLongIterator
implements LongIterator {
    protected final long[] array;
    protected int cursor = 0;

    public static ArrayLongIterator copyOf(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayLongIterator((long[])lArray.clone());
    }

    public ArrayLongIterator(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = lArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public long nextLong() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Long next() {
        return LongUtils.toObject(this.nextLong());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayLongIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

