/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.iterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.iterator.ShortIterator;

public class ArrayShortIterator
implements ShortIterator {
    protected final short[] array;
    protected int cursor = 0;

    public static ArrayShortIterator copyOf(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayShortIterator((short[])sArray.clone());
    }

    public ArrayShortIterator(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = sArray;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public short nextShort() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        return this.array[this.cursor++];
    }

    public Short next() {
        return ShortUtils.toObject(this.nextShort());
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayShortIterator does not support remove");
    }

    public void reset() {
        this.cursor = 0;
    }
}

