/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.collection.impl.AbstractBooleanCollection;
import org.joda.primitives.list.BooleanList;
import org.joda.primitives.listiterator.BooleanListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBooleanList
extends AbstractBooleanCollection
implements BooleanList {
    protected AbstractBooleanList() {
    }

    @Override
    public BooleanListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public BooleanListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public BooleanListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public boolean firstBoolean() {
        return this.getBoolean(0);
    }

    @Override
    public boolean lastBoolean() {
        return this.getBoolean(this.size() - 1);
    }

    @Override
    public boolean contains(boolean bl) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getBoolean(i) != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(boolean bl) {
        return this.indexOf(bl, 0);
    }

    @Override
    public int indexOf(boolean bl, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getBoolean(i) != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean bl) {
        return this.lastIndexOf(bl, this.size());
    }

    @Override
    public int lastIndexOf(boolean bl, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getBoolean(i) != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean[] toBooleanArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        }
        int n3 = n2 - n;
        boolean[] blArray = new boolean[n3];
        this.arrayCopy(n, blArray, 0, n3);
        return blArray;
    }

    @Override
    public BooleanList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(boolean bl) {
        this.checkAddModifiable();
        return this.add(this.size(), bl);
    }

    @Override
    public boolean add(int n, boolean bl) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(boolean[] blArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), blArray);
    }

    @Override
    public boolean addAll(int n, boolean[] blArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (blArray != null) {
            for (int i = 0; i < blArray.length; ++i) {
                bl |= this.add(n + i, blArray[i]);
            }
        }
        return bl;
    }

    @Override
    public boolean removeBooleanAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeBoolean(boolean bl) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getBoolean(i) != bl) continue;
            this.removeBooleanAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeBooleanAt(i);
        }
        return true;
    }

    @Override
    public boolean set(int n, boolean bl) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Boolean get(int n) {
        return BooleanUtils.toObject(this.getBoolean(n));
    }

    @Override
    public Boolean first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Boolean last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(BooleanUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(BooleanUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(BooleanUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(BooleanUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Boolean bl) {
        this.checkAddModifiable();
        return this.add(this.size(), BooleanUtils.toPrimitive(bl));
    }

    @Override
    public void add(int n, Boolean bl) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, BooleanUtils.toPrimitive(bl));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Boolean> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, BooleanUtils.toPrimitiveArray(collection));
    }

    @Override
    public Boolean remove(int n) {
        this.checkRemoveModifiable();
        return BooleanUtils.toObject(this.removeBooleanAt(n));
    }

    @Override
    public Boolean set(int n, Boolean bl) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return BooleanUtils.toObject(this.set(n, BooleanUtils.toPrimitive(bl)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BooleanList) {
            BooleanList booleanList = (BooleanList)object;
            if (this.size() != booleanList.size()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.listIterator();
            BooleanListIterator booleanListIterator2 = booleanList.listIterator();
            while (booleanListIterator.hasNext() && booleanListIterator2.hasNext()) {
                if (booleanListIterator.nextBoolean() == booleanListIterator2.nextBoolean()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (booleanListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (booleanListIterator.nextBoolean() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, boolean[] blArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            blArray[i + n2] = this.getBoolean(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements BooleanListIterator {
        private final AbstractBooleanList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractBooleanList abstractBooleanList, int n) {
            this.iList = abstractBooleanList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getBoolean(this.iCursor++);
        }

        public Boolean next() {
            return this.iList.toObject(this.nextBoolean());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public boolean previousBoolean() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getBoolean(this.iCursor);
        }

        public Boolean previous() {
            return this.iList.toObject(this.previousBoolean());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeBooleanAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(boolean bl) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, bl);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Boolean bl) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(bl));
        }

        public void set(boolean bl) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, bl);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Boolean bl) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(bl));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

