/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.collection.impl.AbstractByteCollection;
import org.joda.primitives.list.ByteList;
import org.joda.primitives.listiterator.ByteListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteList
extends AbstractByteCollection
implements ByteList {
    protected AbstractByteList() {
    }

    @Override
    public ByteListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public byte firstByte() {
        return this.getByte(0);
    }

    @Override
    public byte lastByte() {
        return this.getByte(this.size() - 1);
    }

    @Override
    public boolean contains(byte by) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getByte(i) != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    @Override
    public int indexOf(byte by, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getByte(i) != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte by) {
        return this.lastIndexOf(by, this.size());
    }

    @Override
    public int lastIndexOf(byte by, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getByte(i) != by) continue;
            return i;
        }
        return -1;
    }

    @Override
    public byte[] toByteArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return ByteUtils.EMPTY_BYTE_ARRAY;
        }
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        this.arrayCopy(n, byArray, 0, n3);
        return byArray;
    }

    @Override
    public ByteList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(byte by) {
        this.checkAddModifiable();
        return this.add(this.size(), by);
    }

    @Override
    public boolean add(int n, byte by) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(byte[] byArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), byArray);
    }

    @Override
    public boolean addAll(int n, byte[] byArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                bl |= this.add(n + i, byArray[i]);
            }
        }
        return bl;
    }

    @Override
    public byte removeByteAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeByte(byte by) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getByte(i) != by) continue;
            this.removeByteAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeByteAt(i);
        }
        return true;
    }

    @Override
    public byte set(int n, byte by) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Byte get(int n) {
        return ByteUtils.toObject(this.getByte(n));
    }

    @Override
    public Byte first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Byte last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(ByteUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(ByteUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(ByteUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(ByteUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Byte by) {
        this.checkAddModifiable();
        return this.add(this.size(), ByteUtils.toPrimitive(by));
    }

    @Override
    public void add(int n, Byte by) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, ByteUtils.toPrimitive(by));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Byte> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, ByteUtils.toPrimitiveArray(collection));
    }

    @Override
    public Byte remove(int n) {
        this.checkRemoveModifiable();
        return ByteUtils.toObject(this.removeByteAt(n));
    }

    @Override
    public Byte set(int n, Byte by) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return ByteUtils.toObject(this.set(n, ByteUtils.toPrimitive(by)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            if (this.size() != byteList.size()) {
                return false;
            }
            ByteListIterator byteListIterator = this.listIterator();
            ByteListIterator byteListIterator2 = byteList.listIterator();
            while (byteListIterator.hasNext() && byteListIterator2.hasNext()) {
                if (byteListIterator.nextByte() == byteListIterator2.nextByte()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            ByteListIterator byteListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (byteListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (byteListIterator.nextByte() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[i + n2] = this.getByte(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements ByteListIterator {
        private final AbstractByteList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractByteList abstractByteList, int n) {
            this.iList = abstractByteList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getByte(this.iCursor++);
        }

        public Byte next() {
            return this.iList.toObject(this.nextByte());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public byte previousByte() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getByte(this.iCursor);
        }

        public Byte previous() {
            return this.iList.toObject(this.previousByte());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeByteAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(byte by) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, by);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Byte by) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(by));
        }

        public void set(byte by) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, by);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Byte by) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(by));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

