/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.CharUtils;
import org.joda.primitives.collection.impl.AbstractCharCollection;
import org.joda.primitives.list.CharList;
import org.joda.primitives.listiterator.CharListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharList
extends AbstractCharCollection
implements CharList {
    protected AbstractCharList() {
    }

    @Override
    public CharListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public CharListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public char firstChar() {
        return this.getChar(0);
    }

    @Override
    public char lastChar() {
        return this.getChar(this.size() - 1);
    }

    @Override
    public boolean contains(char c) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getChar(i) != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    @Override
    public int indexOf(char c, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getChar(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.size());
    }

    @Override
    public int lastIndexOf(char c, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getChar(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toStringContents() {
        return new String(this.toCharArray());
    }

    @Override
    public char[] toCharArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return CharUtils.EMPTY_CHAR_ARRAY;
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        this.arrayCopy(n, cArray, 0, n3);
        return cArray;
    }

    @Override
    public CharList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(char c) {
        this.checkAddModifiable();
        return this.add(this.size(), c);
    }

    @Override
    public boolean add(int n, char c) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(char[] cArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), cArray);
    }

    @Override
    public boolean addAll(int n, char[] cArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (cArray != null) {
            for (int i = 0; i < cArray.length; ++i) {
                bl |= this.add(n + i, cArray[i]);
            }
        }
        return bl;
    }

    @Override
    public char removeCharAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeChar(char c) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getChar(i) != c) continue;
            this.removeCharAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeCharAt(i);
        }
        return true;
    }

    @Override
    public char set(int n, char c) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Character get(int n) {
        return CharUtils.toObject(this.getChar(n));
    }

    @Override
    public Character first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Character last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(CharUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(CharUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(CharUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(CharUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Character c) {
        this.checkAddModifiable();
        return this.add(this.size(), CharUtils.toPrimitive(c));
    }

    @Override
    public void add(int n, Character c) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, CharUtils.toPrimitive(c));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Character> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, CharUtils.toPrimitiveArray(collection));
    }

    @Override
    public Character remove(int n) {
        this.checkRemoveModifiable();
        return CharUtils.toObject(this.removeCharAt(n));
    }

    @Override
    public Character set(int n, Character c) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return CharUtils.toObject(this.set(n, CharUtils.toPrimitive(c)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CharList) {
            CharList charList = (CharList)object;
            if (this.size() != charList.size()) {
                return false;
            }
            CharListIterator charListIterator = this.listIterator();
            CharListIterator charListIterator2 = charList.listIterator();
            while (charListIterator.hasNext() && charListIterator2.hasNext()) {
                if (charListIterator.nextChar() == charListIterator2.nextChar()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            CharListIterator charListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (charListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (charListIterator.nextChar() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            cArray[i + n2] = this.getChar(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements CharListIterator {
        private final AbstractCharList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractCharList abstractCharList, int n) {
            this.iList = abstractCharList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getChar(this.iCursor++);
        }

        public Character next() {
            return this.iList.toObject(this.nextChar());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public char previousChar() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getChar(this.iCursor);
        }

        public Character previous() {
            return this.iList.toObject(this.previousChar());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeCharAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(char c) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, c);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Character c) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(c));
        }

        public void set(char c) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, c);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Character c) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(c));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

