/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.collection.impl.AbstractFloatCollection;
import org.joda.primitives.list.FloatList;
import org.joda.primitives.listiterator.FloatListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloatList
extends AbstractFloatCollection
implements FloatList {
    protected AbstractFloatList() {
    }

    @Override
    public FloatListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public FloatListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public float firstFloat() {
        return this.getFloat(0);
    }

    @Override
    public float lastFloat() {
        return this.getFloat(this.size() - 1);
    }

    @Override
    public boolean contains(float f) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getFloat(i) != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(float f) {
        return this.indexOf(f, 0);
    }

    @Override
    public int indexOf(float f, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getFloat(i) != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float f) {
        return this.lastIndexOf(f, this.size());
    }

    @Override
    public int lastIndexOf(float f, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getFloat(i) != f) continue;
            return i;
        }
        return -1;
    }

    @Override
    public float[] toFloatArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return FloatUtils.EMPTY_FLOAT_ARRAY;
        }
        int n3 = n2 - n;
        float[] fArray = new float[n3];
        this.arrayCopy(n, fArray, 0, n3);
        return fArray;
    }

    @Override
    public FloatList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(float f) {
        this.checkAddModifiable();
        return this.add(this.size(), f);
    }

    @Override
    public boolean add(int n, float f) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(float[] fArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), fArray);
    }

    @Override
    public boolean addAll(int n, float[] fArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                bl |= this.add(n + i, fArray[i]);
            }
        }
        return bl;
    }

    @Override
    public float removeFloatAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeFloat(float f) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getFloat(i) != f) continue;
            this.removeFloatAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeFloatAt(i);
        }
        return true;
    }

    @Override
    public float set(int n, float f) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Float get(int n) {
        return FloatUtils.toObject(this.getFloat(n));
    }

    @Override
    public Float first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Float last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(FloatUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(FloatUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(FloatUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(FloatUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Float f) {
        this.checkAddModifiable();
        return this.add(this.size(), FloatUtils.toPrimitive(f));
    }

    @Override
    public void add(int n, Float f) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, FloatUtils.toPrimitive(f));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Float> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, FloatUtils.toPrimitiveArray(collection));
    }

    @Override
    public Float remove(int n) {
        this.checkRemoveModifiable();
        return FloatUtils.toObject(this.removeFloatAt(n));
    }

    @Override
    public Float set(int n, Float f) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return FloatUtils.toObject(this.set(n, FloatUtils.toPrimitive(f)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FloatList) {
            FloatList floatList = (FloatList)object;
            if (this.size() != floatList.size()) {
                return false;
            }
            FloatListIterator floatListIterator = this.listIterator();
            FloatListIterator floatListIterator2 = floatList.listIterator();
            while (floatListIterator.hasNext() && floatListIterator2.hasNext()) {
                if (floatListIterator.nextFloat() == floatListIterator2.nextFloat()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            FloatListIterator floatListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (floatListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (floatListIterator.nextFloat() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, float[] fArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            fArray[i + n2] = this.getFloat(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements FloatListIterator {
        private final AbstractFloatList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractFloatList abstractFloatList, int n) {
            this.iList = abstractFloatList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getFloat(this.iCursor++);
        }

        public Float next() {
            return this.iList.toObject(this.nextFloat());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getFloat(this.iCursor);
        }

        public Float previous() {
            return this.iList.toObject(this.previousFloat());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeFloatAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(float f) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, f);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Float f) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(f));
        }

        public void set(float f) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, f);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Float f) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(f));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

