/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.IntUtils;
import org.joda.primitives.collection.impl.AbstractIntCollection;
import org.joda.primitives.list.IntList;
import org.joda.primitives.listiterator.IntListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList {
    protected AbstractIntList() {
    }

    @Override
    public IntListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public int firstInt() {
        return this.getInt(0);
    }

    @Override
    public int lastInt() {
        return this.getInt(this.size() - 1);
    }

    @Override
    public boolean contains(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.getInt(i) != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    @Override
    public int indexOf(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = this.size();
        for (int i = n2; i < n3; ++i) {
            if (this.getInt(i) != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.size());
    }

    @Override
    public int lastIndexOf(int n, int n2) {
        if (n2 >= this.size()) {
            n2 = this.size() - 1;
        }
        for (int i = n2; i >= 0; --i) {
            if (this.getInt(i) != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] toIntArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return IntUtils.EMPTY_INT_ARRAY;
        }
        int n3 = n2 - n;
        int[] nArray = new int[n3];
        this.arrayCopy(n, nArray, 0, n3);
        return nArray;
    }

    @Override
    public IntList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(int n) {
        this.checkAddModifiable();
        return this.add(this.size(), n);
    }

    @Override
    public boolean add(int n, int n2) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(int[] nArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), nArray);
    }

    @Override
    public boolean addAll(int n, int[] nArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                bl |= this.add(n + i, nArray[i]);
            }
        }
        return bl;
    }

    @Override
    public int removeIntAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeInt(int n) {
        this.checkRemoveModifiable();
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.getInt(i) != n) continue;
            this.removeIntAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeIntAt(i);
        }
        return true;
    }

    @Override
    public int set(int n, int n2) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Integer get(int n) {
        return IntUtils.toObject(this.getInt(n));
    }

    @Override
    public Integer first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Integer last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(IntUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(IntUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(IntUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(IntUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Integer n) {
        this.checkAddModifiable();
        return this.add(this.size(), IntUtils.toPrimitive(n));
    }

    @Override
    public void add(int n, Integer n2) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, IntUtils.toPrimitive(n2));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Integer> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, IntUtils.toPrimitiveArray(collection));
    }

    @Override
    public Integer remove(int n) {
        this.checkRemoveModifiable();
        return IntUtils.toObject(this.removeIntAt(n));
    }

    @Override
    public Integer set(int n, Integer n2) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return IntUtils.toObject(this.set(n, IntUtils.toPrimitive(n2)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntList) {
            IntList intList = (IntList)object;
            if (this.size() != intList.size()) {
                return false;
            }
            IntListIterator intListIterator = this.listIterator();
            IntListIterator intListIterator2 = intList.listIterator();
            while (intListIterator.hasNext() && intListIterator2.hasNext()) {
                if (intListIterator.nextInt() == intListIterator2.nextInt()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            IntListIterator intListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (intListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (intListIterator.nextInt() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[i + n2] = this.getInt(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements IntListIterator {
        private final AbstractIntList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractIntList abstractIntList, int n) {
            this.iList = abstractIntList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getInt(this.iCursor++);
        }

        public Integer next() {
            return this.iList.toObject(this.nextInt());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public int previousInt() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getInt(this.iCursor);
        }

        public Integer previous() {
            return this.iList.toObject(this.previousInt());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeIntAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(int n) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, n);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Integer n) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(n));
        }

        public void set(int n) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Integer n) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(n));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

