/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.LongUtils;
import org.joda.primitives.collection.impl.AbstractLongCollection;
import org.joda.primitives.list.LongList;
import org.joda.primitives.listiterator.LongListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList {
    protected AbstractLongList() {
    }

    @Override
    public LongListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public long firstLong() {
        return this.getLong(0);
    }

    @Override
    public long lastLong() {
        return this.getLong(this.size() - 1);
    }

    @Override
    public boolean contains(long l) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getLong(i) != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(long l) {
        return this.indexOf(l, 0);
    }

    @Override
    public int indexOf(long l, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getLong(i) != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long l) {
        return this.lastIndexOf(l, this.size());
    }

    @Override
    public int lastIndexOf(long l, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getLong(i) != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public long[] toLongArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return LongUtils.EMPTY_LONG_ARRAY;
        }
        int n3 = n2 - n;
        long[] lArray = new long[n3];
        this.arrayCopy(n, lArray, 0, n3);
        return lArray;
    }

    @Override
    public LongList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(long l) {
        this.checkAddModifiable();
        return this.add(this.size(), l);
    }

    @Override
    public boolean add(int n, long l) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(long[] lArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), lArray);
    }

    @Override
    public boolean addAll(int n, long[] lArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                bl |= this.add(n + i, lArray[i]);
            }
        }
        return bl;
    }

    @Override
    public long removeLongAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeLong(long l) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getLong(i) != l) continue;
            this.removeLongAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeLongAt(i);
        }
        return true;
    }

    @Override
    public long set(int n, long l) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Long get(int n) {
        return LongUtils.toObject(this.getLong(n));
    }

    @Override
    public Long first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Long last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(LongUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(LongUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(LongUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(LongUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Long l) {
        this.checkAddModifiable();
        return this.add(this.size(), LongUtils.toPrimitive(l));
    }

    @Override
    public void add(int n, Long l) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, LongUtils.toPrimitive(l));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Long> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, LongUtils.toPrimitiveArray(collection));
    }

    @Override
    public Long remove(int n) {
        this.checkRemoveModifiable();
        return LongUtils.toObject(this.removeLongAt(n));
    }

    @Override
    public Long set(int n, Long l) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return LongUtils.toObject(this.set(n, LongUtils.toPrimitive(l)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LongList) {
            LongList longList = (LongList)object;
            if (this.size() != longList.size()) {
                return false;
            }
            LongListIterator longListIterator = this.listIterator();
            LongListIterator longListIterator2 = longList.listIterator();
            while (longListIterator.hasNext() && longListIterator2.hasNext()) {
                if (longListIterator.nextLong() == longListIterator2.nextLong()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            LongListIterator longListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (longListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (longListIterator.nextLong() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, long[] lArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            lArray[i + n2] = this.getLong(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements LongListIterator {
        private final AbstractLongList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractLongList abstractLongList, int n) {
            this.iList = abstractLongList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getLong(this.iCursor++);
        }

        public Long next() {
            return this.iList.toObject(this.nextLong());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getLong(this.iCursor);
        }

        public Long previous() {
            return this.iList.toObject(this.previousLong());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeLongAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(long l) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, l);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Long l) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(l));
        }

        public void set(long l) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, l);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Long l) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(l));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

