/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.collection.impl.AbstractShortCollection;
import org.joda.primitives.list.ShortList;
import org.joda.primitives.listiterator.ShortListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShortList
extends AbstractShortCollection
implements ShortList {
    protected AbstractShortList() {
    }

    @Override
    public ShortListIterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public ShortListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ShortListIterator listIterator(int n) {
        this.checkIndex(n);
        return new PListIterator(this, n);
    }

    @Override
    public short firstShort() {
        return this.getShort(0);
    }

    @Override
    public short lastShort() {
        return this.getShort(this.size() - 1);
    }

    @Override
    public boolean contains(short s) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getShort(i) != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(short s) {
        return this.indexOf(s, 0);
    }

    @Override
    public int indexOf(short s, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            if (this.getShort(i) != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short s) {
        return this.lastIndexOf(s, this.size());
    }

    @Override
    public int lastIndexOf(short s, int n) {
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if (this.getShort(i) != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public short[] toShortArray(int n, int n2) {
        this.checkRange(n, n2);
        if (n == n2) {
            return ShortUtils.EMPTY_SHORT_ARRAY;
        }
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        this.arrayCopy(n, sArray, 0, n3);
        return sArray;
    }

    @Override
    public ShortList subList(int n, int n2) {
        return null;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean add(short s) {
        this.checkAddModifiable();
        return this.add(this.size(), s);
    }

    @Override
    public boolean add(int n, short s) {
        throw new UnsupportedOperationException("List does not support add");
    }

    @Override
    public boolean addAll(short[] sArray) {
        this.checkAddModifiable();
        return this.addAll(this.size(), sArray);
    }

    @Override
    public boolean addAll(int n, short[] sArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        boolean bl = false;
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                bl |= this.add(n + i, sArray[i]);
            }
        }
        return bl;
    }

    @Override
    public short removeShortAt(int n) {
        throw new UnsupportedOperationException("List does not support remove");
    }

    public boolean removeShort(short s) {
        this.checkRemoveModifiable();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.getShort(i) != s) continue;
            this.removeShortAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeShortAt(i);
        }
        return true;
    }

    @Override
    public short set(int n, short s) {
        throw new UnsupportedOperationException("List does not support set");
    }

    @Override
    public Short get(int n) {
        return ShortUtils.toObject(this.getShort(n));
    }

    @Override
    public Short first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public Short last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(ShortUtils.toPrimitive(object));
    }

    public int indexOf(Object object, int n) {
        return this.indexOf(ShortUtils.toPrimitive(object), n);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(ShortUtils.toPrimitive(object));
    }

    public int lastIndexOf(Object object, int n) {
        return this.lastIndexOf(ShortUtils.toPrimitive(object), n);
    }

    @Override
    public boolean add(Short s) {
        this.checkAddModifiable();
        return this.add(this.size(), ShortUtils.toPrimitive(s));
    }

    @Override
    public void add(int n, Short s) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.add(n, ShortUtils.toPrimitive(s));
    }

    @Override
    public boolean addAll(int n, Collection<? extends Short> collection) {
        this.checkAddModifiable();
        this.checkIndex(n);
        return this.addAll(n, ShortUtils.toPrimitiveArray(collection));
    }

    @Override
    public Short remove(int n) {
        this.checkRemoveModifiable();
        return ShortUtils.toObject(this.removeShortAt(n));
    }

    @Override
    public Short set(int n, Short s) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        return ShortUtils.toObject(this.set(n, ShortUtils.toPrimitive(s)));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ShortList) {
            ShortList shortList = (ShortList)object;
            if (this.size() != shortList.size()) {
                return false;
            }
            ShortListIterator shortListIterator = this.listIterator();
            ShortListIterator shortListIterator2 = shortList.listIterator();
            while (shortListIterator.hasNext() && shortListIterator2.hasNext()) {
                if (shortListIterator.nextShort() == shortListIterator2.nextShort()) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            ShortListIterator shortListIterator = this.listIterator();
            ListIterator listIterator = list.listIterator();
            while (shortListIterator.hasNext() && listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!this.isToPrimitivePossible(e)) {
                    return false;
                }
                if (shortListIterator.nextShort() == this.toPrimitive(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    protected void arrayCopy(int n, short[] sArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            sArray[i + n2] = this.getShort(i + n);
        }
    }

    protected boolean isSetModifiable() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return this.isAddModifiable() || this.isRemoveModifiable() || this.isSetModifiable();
    }

    protected void checkSetModifiable() {
        if (!this.isSetModifiable()) {
            throw new UnsupportedOperationException("Collection does not support set");
        }
    }

    protected void checkIndexExists(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than/equal to size(): " + n + " >= " + this.size());
        }
    }

    protected void checkIndex(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index less than zero: " + n + " < 0");
        }
        if (n > this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index greater than size(): " + n + " > " + this.size());
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("From index less than zero: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new ArrayIndexOutOfBoundsException("To index greater than size(): " + n2 + " > " + this.size());
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("To index greater than from index: " + n + " > " + n2);
        }
    }

    protected static class PListIterator
    implements ShortListIterator {
        private final AbstractShortList iList;
        private final int iStart;
        private int iCursor = 0;
        private int iLastIndex = -1;

        protected PListIterator(AbstractShortList abstractShortList, int n) {
            this.iList = abstractShortList;
            this.iStart = n;
            this.iCursor = n;
        }

        public boolean hasNext() {
            return this.iCursor < this.iList.size();
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = this.iCursor;
            return this.iList.getShort(this.iCursor++);
        }

        public Short next() {
            return this.iList.toObject(this.nextShort());
        }

        public int nextIndex() {
            return this.iCursor;
        }

        public boolean hasPrevious() {
            return this.iCursor > 0;
        }

        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No more elements available");
            }
            this.iLastIndex = --this.iCursor;
            return this.iList.getShort(this.iCursor);
        }

        public Short previous() {
            return this.iList.toObject(this.previousShort());
        }

        public int previousIndex() {
            return this.iCursor - 1;
        }

        public void remove() {
            this.iList.checkRemoveModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be removed");
            }
            this.iList.removeShortAt(this.iLastIndex);
            this.iCursor = this.iLastIndex;
            this.iLastIndex = -1;
        }

        public void add(short s) {
            this.iList.checkAddModifiable();
            try {
                this.iList.add(this.iCursor++, s);
                this.iLastIndex = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void add(Short s) {
            this.iList.checkAddModifiable();
            this.add(this.iList.toPrimitive(s));
        }

        public void set(short s) {
            this.iList.checkSetModifiable();
            if (this.iLastIndex == -1) {
                throw new IllegalStateException("Element cannot be set");
            }
            try {
                this.iList.set(this.iLastIndex, s);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException("The underlying list was modified");
            }
        }

        public void set(Short s) {
            this.iList.checkSetModifiable();
            this.set(this.iList.toPrimitive(s));
        }

        public boolean isModifiable() {
            return this.iList.isModifiable();
        }

        public boolean isResettable() {
            return true;
        }

        public void reset() {
            this.iCursor = this.iStart;
        }
    }
}

