/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.list.impl.AbstractBooleanList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayBooleanList
extends AbstractBooleanList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private boolean[] data;
    private int size;

    public ArrayBooleanList() {
        this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
    }

    public ArrayBooleanList(int n) {
        this.data = n <= 0 ? BooleanUtils.EMPTY_BOOLEAN_ARRAY : new boolean[n];
    }

    public ArrayBooleanList(boolean[] blArray) {
        if (blArray == null) {
            this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        } else {
            this.data = (boolean[])blArray.clone();
            this.size = blArray.length;
        }
    }

    public ArrayBooleanList(Collection<Boolean> collection) {
        if (collection == null) {
            this.data = BooleanUtils.EMPTY_BOOLEAN_ARRAY;
        } else if (collection instanceof ArrayBooleanList) {
            ArrayBooleanList arrayBooleanList = (ArrayBooleanList)collection;
            this.data = new boolean[arrayBooleanList.size];
            System.arraycopy(arrayBooleanList.data, 0, this.data, 0, arrayBooleanList.size);
            this.size = arrayBooleanList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean getBoolean(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, boolean bl) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = bl;
        ++this.size;
        return true;
    }

    @Override
    public boolean removeBooleanAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        boolean bl = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return bl;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public boolean set(int n, boolean bl) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        boolean bl2 = this.data[n];
        this.data[n] = bl;
        return bl2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            boolean[] blArray = new boolean[this.size];
            System.arraycopy(this.data, 0, blArray, 0, this.size);
            this.data = blArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(boolean bl) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, boolean[] blArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (blArray == null || blArray.length == 0) {
            return false;
        }
        int n2 = blArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(blArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayBooleanList arrayBooleanList = (ArrayBooleanList)super.clone();
        arrayBooleanList.data = (boolean[])this.data.clone();
        return arrayBooleanList;
    }

    @Override
    protected void arrayCopy(int n, boolean[] blArray, int n2, int n3) {
        System.arraycopy(this.data, n, blArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        boolean[] blArray = new boolean[n3];
        System.arraycopy(this.data, 0, blArray, 0, n2);
        this.data = blArray;
    }
}

