/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.list.impl.AbstractByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayByteList
extends AbstractByteList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private byte[] data;
    private int size;

    public ArrayByteList() {
        this.data = ByteUtils.EMPTY_BYTE_ARRAY;
    }

    public ArrayByteList(int n) {
        this.data = n <= 0 ? ByteUtils.EMPTY_BYTE_ARRAY : new byte[n];
    }

    public ArrayByteList(byte[] byArray) {
        if (byArray == null) {
            this.data = ByteUtils.EMPTY_BYTE_ARRAY;
        } else {
            this.data = (byte[])byArray.clone();
            this.size = byArray.length;
        }
    }

    public ArrayByteList(Collection<Byte> collection) {
        if (collection == null) {
            this.data = ByteUtils.EMPTY_BYTE_ARRAY;
        } else if (collection instanceof ArrayByteList) {
            ArrayByteList arrayByteList = (ArrayByteList)collection;
            this.data = new byte[arrayByteList.size];
            System.arraycopy(arrayByteList.data, 0, this.data, 0, arrayByteList.size);
            this.size = arrayByteList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte getByte(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, byte by) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = by;
        ++this.size;
        return true;
    }

    @Override
    public byte removeByteAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        byte by = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return by;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public byte set(int n, byte by) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        byte by2 = this.data[n];
        this.data[n] = by;
        return by2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.data, 0, byArray, 0, this.size);
            this.data = byArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(byte by) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, byte[] byArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        int n2 = byArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(byArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayByteList arrayByteList = (ArrayByteList)super.clone();
        arrayByteList.data = (byte[])this.data.clone();
        return arrayByteList;
    }

    @Override
    protected void arrayCopy(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, n, byArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.data, 0, byArray, 0, n2);
        this.data = byArray;
    }
}

